/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.health.checks;

import io.smallrye.health.checks.HealthChecksLogging;
import java.net.HttpURLConnection;
import java.net.URL;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

public class UrlHealthCheck
implements HealthCheck {
    static final String DEFAULT_NAME = "Url Check";
    static final int DEFAULT_TIMEOUT = 2000;
    static final String DEFAULT_REQUEST_METHOD = "GET";
    static final int DEFAULT_EXPECTED_STATUS_CODE = 200;
    private String url;
    private String name;
    private int timeout;
    private String requestMethod;
    private int statusCode;

    public UrlHealthCheck(String url) {
        this.url = url;
        this.requestMethod = DEFAULT_REQUEST_METHOD;
        this.statusCode = 200;
        this.name = DEFAULT_NAME;
        this.timeout = 2000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthCheckResponse call() {
        HealthCheckResponseBuilder healthCheckResponseBuilder = HealthCheckResponse.named((String)this.name);
        healthCheckResponseBuilder.withData("host", String.format("%s %s", this.requestMethod, this.url));
        HttpURLConnection httpUrlConn = null;
        try {
            boolean isUp;
            httpUrlConn = (HttpURLConnection)new URL(this.url).openConnection();
            httpUrlConn.setRequestMethod(this.requestMethod);
            httpUrlConn.setConnectTimeout(this.timeout);
            httpUrlConn.setReadTimeout(this.timeout);
            boolean bl = isUp = httpUrlConn.getResponseCode() == this.statusCode;
            if (!isUp) {
                healthCheckResponseBuilder.withData("error", String.format("Expected response code %d but actual is %d", this.statusCode, httpUrlConn.getResponseCode()));
            }
            healthCheckResponseBuilder.status(isUp);
        }
        catch (Exception e) {
            HealthChecksLogging.logger.urlHealthCheckError(e);
            healthCheckResponseBuilder.withData("error", String.format("%s: %s", e.getClass().getCanonicalName(), e.getMessage()));
            healthCheckResponseBuilder.down();
        }
        finally {
            if (httpUrlConn != null) {
                httpUrlConn.disconnect();
            }
        }
        return healthCheckResponseBuilder.build();
    }

    public UrlHealthCheck name(String name) {
        this.name = name;
        return this;
    }

    public UrlHealthCheck timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public UrlHealthCheck statusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public UrlHealthCheck requestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }
}

