/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import mediathek.config.MVColor;
import mediathek.config.MVConfig;
import mediathek.config.StandardLocations;
import mediathek.daten.DatenDownload;
import mediathek.tool.FileSpecifier;
import mediathek.tool.FilenameUtils;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.SVGIconUtilities;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MVPanelDownloadZiel
extends JPanel {
    public boolean nameGeaendert;
    private final DatenDownload datenDownload;
    private final JFrame parent;
    private final boolean letztenPfadAnzeigen;
    private static final Logger logger = LogManager.getLogger();
    private JButton jButtonDelPath;
    private JButton jButtonPath;
    private JComboBox<String> jComboBoxPath;
    private JLabel jLabelExists;
    private JTextField jTextFieldName;

    public MVPanelDownloadZiel(JFrame p, DatenDownload download, boolean letzterPfad) {
        this.initComponents();
        this.parent = p;
        this.datenDownload = download;
        this.letztenPfadAnzeigen = letzterPfad;
        this.jButtonPath.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/folder-open.svg"));
        this.jButtonDelPath.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/trash-can.svg"));
        this.jLabelExists.setText("");
        this.jButtonPath.addActionListener(new ZielBeobachter());
        this.jButtonDelPath.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD__PFADE_ZUM_SPEICHERN, "");
            this.jComboBoxPath.setModel(new DefaultComboBoxModel<String>(new String[]{this.datenDownload.arr[30]}));
        });
        this.jTextFieldName.setText(this.datenDownload.arr[29]);
        this.jTextFieldName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.tus();
            }

            private void tus() {
                MVPanelDownloadZiel.this.nameGeaendert = true;
                MVPanelDownloadZiel.this.checkPfadName();
                String n1 = MVPanelDownloadZiel.this.jTextFieldName.getText();
                String n2 = FilenameUtils.checkDateiname(n1, false);
                if (!n1.equals(n2)) {
                    MVPanelDownloadZiel.this.jTextFieldName.setBackground(MVColor.DOWNLOAD_FEHLER.color);
                } else {
                    MVPanelDownloadZiel.this.jTextFieldName.setBackground(UIManager.getDefaults().getColor("TextField.background"));
                }
            }
        });
        this.setModelPfad(this.datenDownload.arr[30]);
        ((JTextComponent)this.jComboBoxPath.getEditor().getEditorComponent()).setOpaque(true);
        ((JTextComponent)this.jComboBoxPath.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.tus();
            }

            private void tus() {
                MVPanelDownloadZiel.this.nameGeaendert = true;
                MVPanelDownloadZiel.this.checkPfadName();
                String s = ((JTextComponent)MVPanelDownloadZiel.this.jComboBoxPath.getEditor().getEditorComponent()).getText();
                Component editor = MVPanelDownloadZiel.this.jComboBoxPath.getEditor().getEditorComponent();
                if (!s.equals(FilenameUtils.checkDateiname(s, true))) {
                    editor.setBackground(MVColor.DOWNLOAD_FEHLER.color);
                } else {
                    editor.setBackground(UIManager.getDefaults().getColor("TextField.background"));
                }
            }
        });
        this.checkPfadName();
    }

    private void setModelPfad(String pfad) {
        ArrayList<String> pfade = new ArrayList<String>();
        if (!this.letztenPfadAnzeigen && !pfad.isEmpty()) {
            pfade.add(pfad);
        }
        if (!MVConfig.get(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD__PFADE_ZUM_SPEICHERN).isEmpty()) {
            String[] p;
            for (String s : p = MVConfig.get(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD__PFADE_ZUM_SPEICHERN).split("<>")) {
                if (pfade.contains(s)) continue;
                pfade.add(s);
            }
        }
        if (this.letztenPfadAnzeigen && !pfad.isEmpty() && !pfade.contains(pfad)) {
            pfade.add(pfad);
        }
        this.jComboBoxPath.setModel(new DefaultComboBoxModel<String>(pfade.toArray(new String[0])));
    }

    private void checkPfadName() {
        String pfad = ((JTextComponent)this.jComboBoxPath.getEditor().getEditorComponent()).getText();
        String name = this.jTextFieldName.getText();
        String p = pfad.endsWith(File.separator) ? pfad.substring(0, pfad.length() - 1) : pfad;
        String pfadName = GuiFunktionen.concatPaths(p, name);
        try {
            File file = new File(pfadName);
            if (file.exists()) {
                this.jLabelExists.setForeground(Color.RED);
                this.jLabelExists.setText("Datei existiert schon!");
            } else if (!this.jTextFieldName.getText().equals(this.datenDownload.arr[29]) || !((JTextComponent)this.jComboBoxPath.getEditor().getEditorComponent()).getText().equals(this.datenDownload.arr[30])) {
                this.jLabelExists.setForeground(MVColor.DOWNLOAD_DATEINAME_NEU.color);
                this.jLabelExists.setText("Neuer Name");
            } else {
                this.jLabelExists.setForeground(MVColor.DOWNLOAD_DATEINAME_ALT.color);
                this.jLabelExists.setText("");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean setPfadName_geaendert() {
        String pfad = this.jComboBoxPath.getSelectedItem().toString();
        Object name = this.jTextFieldName.getText();
        if (pfad.endsWith(File.separator)) {
            pfad = pfad.substring(0, pfad.length() - 1);
        }
        if (pfad.isEmpty()) {
            pfad = StandardLocations.getStandardDownloadPath();
        }
        if (((String)name).isEmpty()) {
            name = new SimpleDateFormat("yyyyMMdd").format(new Date()) + "_" + this.datenDownload.arr[4] + "-" + this.datenDownload.arr[5] + ".mp4";
        }
        FileSpecifier fileSpecifier = new FileSpecifier(pfad, (String)name);
        fileSpecifier.checkLength();
        if (!fileSpecifier.getPath().equals(pfad) || !fileSpecifier.getFileName().equals(name)) {
            MVMessageDialog.showMessageDialog(this.parent, "Dateiname war zu lang und wurde gek\u00fcrzt!", "Pfad zu lang!", 0);
        }
        String orgPfad = this.datenDownload.arr[31];
        this.datenDownload.arr[29] = fileSpecifier.getFileName();
        this.datenDownload.arr[30] = fileSpecifier.getPath();
        this.datenDownload.arr[31] = GuiFunktionen.addsPfad(fileSpecifier.getPath(), fileSpecifier.getFileName());
        return !orgPfad.equals(this.datenDownload.arr[31]);
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        this.jComboBoxPath = new JComboBox();
        this.jButtonPath = new JButton();
        this.jButtonDelPath = new JButton();
        JLabel jLabel2 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabelExists = new JLabel();
        jLabel1.setText("Zielpfad:");
        this.jComboBoxPath.setEditable(true);
        this.jButtonPath.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonPath.setToolTipText("Zielpfad ausw\u00e4hlen");
        this.jButtonDelPath.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-del.png")));
        this.jButtonDelPath.setToolTipText("gespeicherte Pfade l\u00f6schen");
        jLabel2.setText("Dateiname:");
        this.jLabelExists.setText("Datei existiert schon!");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelExists).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel2).addComponent(jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jComboBoxPath, 0, 445, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelPath)).addComponent(this.jTextFieldName)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(this.jComboBoxPath, -2, -1, -2).addComponent(this.jButtonPath).addComponent(this.jButtonDelPath)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.jTextFieldName, -2, -1, -2)).addGap(10, 10, 10).addComponent(this.jLabelExists).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(1, this.jButtonDelPath, this.jButtonPath, this.jComboBoxPath, this.jTextFieldName);
    }

    private class ZielBeobachter
    implements ActionListener {
        private ZielBeobachter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemUtils.IS_OS_MAC_OSX) {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                FileDialog chooser = new FileDialog((Frame)MVPanelDownloadZiel.this.parent, "Film speichern");
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        MVPanelDownloadZiel.this.jComboBoxPath.addItem(chooser.getDirectory() + chooser.getFile());
                        MVPanelDownloadZiel.this.jComboBoxPath.setSelectedItem(chooser.getDirectory() + chooser.getFile());
                    }
                    catch (Exception ex) {
                        logger.error("actionPerformed", (Throwable)ex);
                    }
                }
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            } else {
                JFileChooser chooser = new JFileChooser();
                String selItem = Objects.requireNonNull(MVPanelDownloadZiel.this.jComboBoxPath.getSelectedItem()).toString();
                if (!selItem.isEmpty()) {
                    chooser.setCurrentDirectory(new File(selItem));
                }
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        MVPanelDownloadZiel.this.jComboBoxPath.addItem(chooser.getSelectedFile().getAbsolutePath());
                        MVPanelDownloadZiel.this.jComboBoxPath.setSelectedItem(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        logger.error("actionPerformed", (Throwable)ex);
                    }
                }
            }
        }
    }
}

