/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout.region;

import com.sun.javafx.util.InterpolationUtils;
import java.util.Objects;
import javafx.animation.Interpolatable;
import javafx.scene.layout.BorderWidths;

public final class BorderImageSlices
implements Interpolatable<BorderImageSlices> {
    public static final BorderImageSlices EMPTY = new BorderImageSlices(BorderWidths.EMPTY, false);
    public static final BorderImageSlices DEFAULT = new BorderImageSlices(BorderWidths.FULL, false);
    public BorderWidths widths;
    public boolean filled;

    public BorderImageSlices(BorderWidths borderWidths, boolean bl) {
        this.widths = borderWidths;
        this.filled = bl;
    }

    @Override
    public BorderImageSlices interpolate(BorderImageSlices borderImageSlices, double d) {
        Objects.requireNonNull(borderImageSlices, "endValue cannot be null");
        if (d <= 0.0 || this.equals(borderImageSlices)) {
            return this;
        }
        if (d >= 1.0) {
            return borderImageSlices;
        }
        return new BorderImageSlices(this.widths.interpolate(borderImageSlices.widths, d), InterpolationUtils.interpolateDiscrete(this.filled, borderImageSlices.filled, d));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BorderImageSlices)) {
            return false;
        }
        BorderImageSlices borderImageSlices = (BorderImageSlices)object;
        return this.filled == borderImageSlices.filled && Objects.equals(this.widths, borderImageSlices.widths);
    }

    public int hashCode() {
        int n = Objects.hashCode(this.widths);
        n = 31 * n + Boolean.hashCode(this.filled);
        return n;
    }
}

