/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.regex;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Lazy;
import net.sourceforge.plantuml.regex.Matcher2;

public class Pattern2 {
    private static final ConcurrentHashMap<String, AtomicInteger> COUNT = new ConcurrentHashMap();
    private static final Pattern2 EMPTY = new Pattern2("");
    private final String patternString;
    private final Lazy<Pattern> pattern;
    private static final Map<String, String> QUOTED_REPLACEMENTS = new HashMap<String, String>();
    private static final Pattern TRANSFORM_PATTERN;

    private Pattern2(String s) {
        this.patternString = s;
        this.pattern = new Lazy<Pattern>(() -> Pattern2.compileInternal(this.patternString));
    }

    public Matcher2 matcher(CharSequence input) {
        return Matcher2.build(this.pattern.get(), input);
    }

    public String pattern() {
        return this.patternString;
    }

    public static Pattern2 cmpile(String p) {
        if (p == null || p.length() == 0) {
            return EMPTY;
        }
        return new Pattern2(p);
    }

    public static Pattern compileInternal(String patternString) {
        return Pattern.compile(Pattern2.transform(patternString), 2);
    }

    private static String transformOld(String p) {
        p = p.replace("%pLN", "\\p{L}\\p{N}");
        p = p.replace("%s", "\\s\u00a0");
        p = p.replace("%q", "'\u2018\u2019");
        p = p.replace("%g", "\"\u201c\u201d\ue121");
        return p;
    }

    public static String transform(String input) {
        Matcher m = TRANSFORM_PATTERN.matcher(input);
        StringBuffer sb = new StringBuffer(input.length());
        while (m.find()) {
            String replacement = QUOTED_REPLACEMENTS.get(m.group());
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    static {
        QUOTED_REPLACEMENTS.put("%pLN", Matcher.quoteReplacement("\\p{L}\\p{N}"));
        QUOTED_REPLACEMENTS.put("%s", Matcher.quoteReplacement("\\s\u00a0"));
        QUOTED_REPLACEMENTS.put("%q", Matcher.quoteReplacement("'\u2018\u2019"));
        QUOTED_REPLACEMENTS.put("%g", Matcher.quoteReplacement("\"\u201c\u201d\ue121"));
        TRANSFORM_PATTERN = Pattern.compile("%(pLN|s|q|g)");
    }
}

