/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class JdbcLogFormatter
extends Formatter {
    protected static final String format = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    protected final ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(JdbcLogFormatter.format);
        }
    };

    @Override
    public String format(LogRecord record) {
        String message = this.formatMessage(record);
        String throwable = "";
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            record.getThrown().printStackTrace(pw);
            pw.close();
            throwable = sw.toString();
        }
        return MessageFormat.format("{0} [{1}] {2} {3}.{4} - {5} {6}\n", this.dateFormat.get().format(new Date(record.getMillis())), Thread.currentThread().getName(), record.getLevel().getName(), record.getLoggerName(), record.getSourceMethodName(), message, throwable);
    }
}

