[![Build](https://github.com/pioneerspacesim/pioneer/workflows/Build%20Pioneer/badge.svg)](https://github.com/pioneerspacesim/pioneer/actions)
[![License GPLv3](https://img.shields.io/badge/license-GPL_v3-green.svg)](http://www.gnu.org/licenses/gpl-3.0.html)
[![#pioneer on Libera.Chat](https://img.shields.io/badge/LiberaChat-%23pioneer-brightgreen.svg)](https://kiwiirc.com/client/irc.libera.chat/pioneer)
[![Github All Releases](https://img.shields.io/github/downloads/pioneerspacesim/pioneer/latest/total)]()


# Pioneer Space Simulator

![](https://github.com/pioneerspacesim/pioneer/blob/master/data/icons/badge.png)

Pioneer is a space adventure game set in the Milky Way galaxy at the turn of
the 31st century.

The game is open-ended, and you are free to explore the millions of star
systems in the game. You can land on planets, slingshot past gas giants, and
burn yourself to a crisp flying between binary star systems. You can try your
hand at piracy, make your fortune trading between systems, or do missions for
the various factions fighting for power, freedom or self-determination.

For more information, see:
  http://pioneerspacesim.net/


## Community

Come by #pioneer at irc.libera.chat and say hi to the team:
  https://kiwiirc.com/client/irc.libera.chat/pioneer

Bugs? Please log an issue:
  https://github.com/pioneerspacesim/pioneer/issues

Follow Pioneer on Twitter:
  https://twitter.com/pioneerspacesim/

Pioneer wiki
  https://wiki.pioneerspacesim.net

Join the player's forum:
  http://spacesimcentral.com/community/pioneer/

Join the development forum:
  http://forum.pioneerspacesim.net


## Manual

Manual can be found at:
  https://wiki.pioneerspacesim.net/wiki/Manual

Basic flight:
  https://wiki.pioneerspacesim.net/wiki/Basic_flight

Keyboard and mouse control is found at:
  https://wiki.pioneerspacesim.net/wiki/Keyboard_and_mouse_controls


## FAQ

For frequently asked questions, please see
  https://wiki.pioneerspacesim.net/wiki/FAQ


## BUG Reporting

Please see the section of the FAQ pertaining to bugs, crashes and reporting other issues: [Bug Reporting FAQs](https://wiki.pioneerspacesim.net/wiki/FAQ#How.2Fwhere_do_I_report_my_bug.2Fcrash).

Please do your best to fill out the issue template as completely as possible, especially when you're reporting a crash bug or a graphical issue. Having system information including graphics drivers and the method you used to install Pioneer helps immensely to diagnose and fix these kinds of issues.

## Contributing

If you are hungry to contribute, more information can be found here:
  https://wiki.pioneerspacesim.net/wiki/How_you_can_contribute

If you have a contribution you want to share, and want to learn how to make a
pull request, see:
  https://dev.pioneerspacesim.net/contribute/git-and-github

Pioneer development documentation
  https://dev.pioneerspacesim.net/

### AI Policy

Pioneer does not accept AI-generated code contributions. Code contributions generated by AI do not comply with and cannot be licensed under Pioneer's GPLv3 license, and as such the project maintainers will reject pull requests containing wholly or in large part AI-generated code.

We do not condemn the use of AI-powered autocomplete as a secondary assistive tool for experienced programmers, but cannot accept any contributions where AI-generated code forms a material part of the contribution. This includes AI-generated comments and design suggestions.

## Localization

Localization for Pioneer is handled trough Transifex, and pulled to the source from there automatically. Because of this please don't make pull requests for translations. [You can find the localization project here.](https://www.transifex.com/pioneer/pioneer/dashboard/)
You need to register at transifex to be able to access the translations.

If you want a new language introduced, [please request it on the Libera IRC channel of Pioneer](https://web.libera.chat/#pioneer), or here by making an issue for it.

## Getting Pioneer

Latest build is available at
  https://pioneerspacesim.net/page/download/

For compiling from source, please see [COMPILING.txt](https://github.com/pioneerspacesim/pioneer/blob/master/COMPILING.txt)


## Changelog

Please see [Changelog.txt](https://github.com/pioneerspacesim/pioneer/blob/master/Changelog.txt)
