/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.util.Arrays;
import mediathek.tool.GermanStringSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DatenAbo
implements Comparable<DatenAbo> {
    public static final int ABO_NR = 0;
    public static final int ABO_EINGESCHALTET = 1;
    public static final int ABO_NAME = 2;
    public static final int ABO_SENDER = 3;
    public static final int ABO_THEMA = 4;
    public static final int ABO_TITEL = 5;
    public static final int ABO_THEMA_TITEL = 6;
    public static final int ABO_IRGENDWO = 7;
    public static final int ABO_MINDESTDAUER = 8;
    public static final int ABO_MIN = 9;
    public static final int ABO_ZIELPFAD = 10;
    public static final int ABO_DOWN_DATUM = 11;
    public static final int ABO_PSET = 12;
    public static final String[] COLUMN_NAMES = new String[]{"Nr", "aktiv", "Name", "Sender", "Thema", "Titel", "Thema-Titel", "Irgendwo", "Dauer", "min/max", "Zielpfad", "letztes Abo", "Programmset"};
    public static final String[] XML_NAMES = new String[]{"Nr", "aktiv", "Name", "Sender", "Thema", "Titel", "Thema-Titel", "Irgendwo", "Mindestdauer", "min_max", "Zielpfad", "letztes_Abo", "Programmset"};
    public static final int MAX_ELEM = 13;
    public static final String TAG = "Abonnement";
    private static final Logger logger = LogManager.getLogger(DatenAbo.class);
    public static boolean[] spaltenAnzeigen = new boolean[13];
    private final GermanStringSorter sorter = GermanStringSorter.getInstance();
    public int mindestdauerMinuten;
    public boolean min = true;
    public String[] arr;
    public int nr;
    public String[] titel;
    public String[] thema;
    public String[] irgendwo;

    public DatenAbo() {
        this.initialize();
    }

    public DatenAbo(String name, String sender, String thema, String titel, String themaTitel, String irgendwo, int mmindestdauerMinuten, boolean min2, String ziel, String pset) {
        this.initialize();
        this.arr[2] = name;
        this.arr[3] = sender;
        this.arr[4] = thema;
        this.arr[5] = titel;
        this.arr[6] = themaTitel;
        this.arr[7] = irgendwo;
        this.setMindestDauerMinuten(mmindestdauerMinuten);
        this.arr[9] = Boolean.toString(min2);
        this.min = min2;
        this.arr[10] = ziel;
        this.arr[12] = pset;
    }

    public static boolean anzeigen(int i) {
        return spaltenAnzeigen == null || spaltenAnzeigen[i];
    }

    public DatenAbo getCopy() {
        DatenAbo ret = new DatenAbo();
        System.arraycopy(this.arr, 0, ret.arr, 0, this.arr.length);
        ret.mindestdauerMinuten = this.mindestdauerMinuten;
        ret.min = this.min;
        return ret;
    }

    public boolean isEmpty() {
        return this.arr[3].isEmpty() && this.arr[4].isEmpty() && this.arr[5].isEmpty() && this.arr[6].isEmpty() && this.arr[7].isEmpty();
    }

    public final void setMindestDauerMinuten(int d) {
        this.mindestdauerMinuten = d;
        this.arr[8] = String.valueOf(d);
    }

    public void setMindestDauerMinuten() {
        if (this.arr[8].isEmpty()) {
            this.mindestdauerMinuten = 0;
            this.arr[8] = "0";
        }
        try {
            this.mindestdauerMinuten = Integer.parseInt(this.arr[8]);
        }
        catch (Exception ex) {
            logger.error("setMindestDauerMinuten()", (Throwable)ex);
            this.mindestdauerMinuten = 0;
            this.arr[8] = "0";
        }
    }

    public boolean aboIstEingeschaltet() {
        if (this.arr[1].isEmpty()) {
            this.aboEin();
            return true;
        }
        return Boolean.parseBoolean(this.arr[1]);
    }

    private void aboEin() {
        this.arr[1] = String.valueOf(true);
    }

    private void initialize() {
        this.arr = new String[13];
        Arrays.fill(this.arr, "");
        this.aboEin();
    }

    @Override
    public int compareTo(@NotNull DatenAbo arg0) {
        return this.sorter.compare(this.arr[2], arg0.arr[2]);
    }
}

