/*
 * Decompiled with CFR 0.152.
 */
package mediathek.filmlisten;

import mediathek.daten.ListeFilme;
import mediathek.filmlisten.FilmListDownloadType;
import mediathek.filmlisten.IAction;
import mediathek.filmlisten.IDownloadAction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class FilmeImportierenAutoThread
extends Thread {
    private static final Logger logger = LogManager.getLogger(FilmeImportierenAutoThread.class);
    private final ListeFilme listeFilme;
    private final ListeFilme listeFilmeDiff;
    private final int days;
    private final IAction onFinished;
    private final IDownloadAction downloadAction;

    public FilmeImportierenAutoThread(ListeFilme listeFilme, ListeFilme listeFilmeDiff, int days, IDownloadAction downloadAction, IAction onFinished) {
        this.listeFilme = listeFilme;
        this.listeFilmeDiff = listeFilmeDiff;
        this.days = days;
        this.onFinished = onFinished;
        this.downloadAction = downloadAction;
        this.setName("FilmeImportierenAutoThread");
    }

    @Override
    public void run() {
        boolean ret;
        if (this.listeFilme.isTooOldForDiff()) {
            this.listeFilme.clear();
            ret = this.searchFullList(this.listeFilme, FilmListDownloadType.FULL);
        } else {
            ret = this.searchFullList(this.listeFilmeDiff, FilmListDownloadType.DIFF_ONLY);
            if (!ret || this.listeFilmeDiff.isEmpty()) {
                this.listeFilme.clear();
                this.listeFilmeDiff.clear();
                ret = this.searchFullList(this.listeFilme, FilmListDownloadType.FULL);
            }
        }
        if (!ret) {
            logger.error("Es konnten keine Filme geladen werden!");
        }
        this.onFinished.onFinished(ret);
    }

    private boolean searchFullList(ListeFilme liste, FilmListDownloadType state) {
        Object updateUrl = "https://liste.mediathekviewweb.de/";
        switch (state) {
            case FULL: {
                updateUrl = (String)updateUrl + "Filmliste-akt.xz";
                break;
            }
            case DIFF_ONLY: {
                updateUrl = (String)updateUrl + "Filmliste-diff.xz";
            }
        }
        return this.downloadAction.performDownload((String)updateUrl, liste, this.days);
    }
}

