/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import mediathek.config.Daten;
import mediathek.config.Icons;
import mediathek.config.MVColor;
import mediathek.config.MVConfig;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.gui.messages.DownloadListChangedEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.ByteUnitUtil;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.FilenameUtils;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.Log;
import mediathek.tool.MVMessageDialog;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.SystemUtils;

public class DialogAddDownload
extends JDialog {
    private DatenPset pSet;
    private boolean ok = false;
    private DatenDownload datenDownload = null;
    private final Daten daten;
    private final DatenFilm datenFilm;
    private String orgPfad = "";
    private final String aufloesung;
    private String dateiGroesse_HD = "";
    private String dateiGroesse_Hoch = "";
    private String dateiGroesse_Klein = "";
    private boolean nameGeaendert = false;
    private boolean stopBeob = false;
    private final JTextComponent cbPathTextComponent;
    private final Configuration config = ApplicationConfiguration.getConfiguration();
    private final TitledBorder filmBorder;
    private static final String TITLED_BORDER_STRING = "Download-Qualit\u00e4t";
    private JButton jButtonAbbrechen;
    private JButton jButtonDelHistory;
    private JButton jButtonOk;
    private JButton jButtonZiel;
    private JCheckBox jCheckBoxInfodatei;
    private JCheckBox jCheckBoxPfadSpeichern;
    private JCheckBox jCheckBoxStarten;
    private JCheckBox jCheckBoxSubtitle;
    private JComboBox<String> jComboBoxPfad;
    private JComboBox<String> jComboBoxPset;
    private JLabel jLabelSet;
    private JPanel jPanelSize;
    private JRadioButton jRadioButtonAufloesungHd;
    private JRadioButton jRadioButtonAufloesungHoch;
    private JRadioButton jRadioButtonAufloesungKlein;
    private JTextField jTextFieldName;
    private JTextField jTextFieldSender;

    public DialogAddDownload(Frame parent, Daten daten, DatenFilm film, DatenPset pSet, String aufloesung) {
        super(parent, true);
        this.initComponents();
        this.filmBorder = (TitledBorder)this.jPanelSize.getBorder();
        this.cbPathTextComponent = (JTextComponent)this.jComboBoxPfad.getEditor().getEditorComponent();
        this.aufloesung = aufloesung;
        this.daten = daten;
        this.datenFilm = film;
        this.pSet = pSet;
        this.init();
        this.packIt();
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        }
    }

    private void packIt() {
        int w = this.getWidth();
        this.pack();
        this.setSize(w, this.getHeight());
    }

    private void init() {
        this.jButtonDelHistory.setIcon(Icons.ICON_BUTTON_DEL);
        this.jComboBoxPset.setModel(new DefaultComboBoxModel<String>(Daten.listePset.getListeSpeichern().getObjectDataCombo()));
        this.jCheckBoxStarten.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD_D_STARTEN)));
        this.jCheckBoxStarten.addActionListener(e -> MVConfig.add(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD_D_STARTEN, String.valueOf(this.jCheckBoxStarten.isSelected())));
        this.jButtonZiel.setIcon(Icons.ICON_BUTTON_FILE_OPEN);
        this.jButtonZiel.setText("");
        if (Daten.listePset.getListeSpeichern().isEmpty()) {
            this.ok = false;
            this.beenden();
        }
        this.jButtonZiel.addActionListener(new ZielBeobachter());
        this.jButtonOk.addActionListener(e -> {
            if (this.check()) {
                this.beenden();
            }
        });
        this.getRootPane().setDefaultButton(this.jButtonOk);
        EscapeKeyHandler.installHandler(this, () -> {
            this.ok = false;
            this.beenden();
        });
        this.jButtonAbbrechen.addActionListener(e -> {
            this.ok = false;
            this.beenden();
        });
        if (this.pSet != null) {
            this.jComboBoxPset.setSelectedItem(this.pSet.arr[0]);
        } else {
            this.pSet = (DatenPset)Daten.listePset.getListeSpeichern().get(this.jComboBoxPset.getSelectedIndex());
        }
        if (Daten.listePset.getListeSpeichern().size() == 1) {
            this.jLabelSet.setVisible(false);
            this.jComboBoxPset.setVisible(false);
            this.jComboBoxPset.setEnabled(false);
        } else {
            this.jComboBoxPset.addActionListener(e -> this.setupResolutionButtons());
        }
        this.jTextFieldSender.setText(" " + this.datenFilm.getSender() + ":   " + this.datenFilm.getTitle());
        this.jTextFieldName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.tus();
            }

            private void tus() {
                if (!DialogAddDownload.this.stopBeob) {
                    DialogAddDownload.this.nameGeaendert = true;
                    if (!DialogAddDownload.this.jTextFieldName.getText().equals(FilenameUtils.checkDateiname(DialogAddDownload.this.jTextFieldName.getText(), false))) {
                        DialogAddDownload.this.jTextFieldName.setBackground(MVColor.DOWNLOAD_FEHLER.color);
                    } else {
                        DialogAddDownload.this.jTextFieldName.setBackground(UIManager.getDefaults().getColor("TextField.background"));
                    }
                }
            }
        });
        this.cbPathTextComponent.setOpaque(true);
        this.cbPathTextComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.tus();
            }

            private void tus() {
                if (!DialogAddDownload.this.stopBeob) {
                    DialogAddDownload.this.nameGeaendert = true;
                    if (!SystemUtils.IS_OS_WINDOWS) {
                        String s2 = DialogAddDownload.this.cbPathTextComponent.getText();
                        if (!s2.equals(FilenameUtils.checkDateiname(s2, true))) {
                            DialogAddDownload.this.jComboBoxPfad.getEditor().getEditorComponent().setBackground(MVColor.DOWNLOAD_FEHLER.color);
                        } else {
                            DialogAddDownload.this.jComboBoxPfad.getEditor().getEditorComponent().setBackground(Color.WHITE);
                        }
                    }
                    DialogAddDownload.this.calculateAndCheckDiskSpace();
                }
            }
        });
        this.jRadioButtonAufloesungHd.addActionListener(new BeobRadio());
        this.jRadioButtonAufloesungKlein.addActionListener(new BeobRadio());
        this.jRadioButtonAufloesungHoch.addActionListener(new BeobRadio());
        this.jRadioButtonAufloesungHd.setEnabled(!this.datenFilm.getHighQualityUrl().isEmpty());
        this.jRadioButtonAufloesungKlein.setEnabled(!this.datenFilm.getUrlKlein().isEmpty());
        this.jRadioButtonAufloesungHoch.setSelected(true);
        if (this.jRadioButtonAufloesungHd.isEnabled()) {
            this.dateiGroesse_HD = this.datenFilm.getDateigroesse(this.datenFilm.getUrlFuerAufloesung("hd"));
            if (!this.dateiGroesse_HD.isEmpty()) {
                this.jRadioButtonAufloesungHd.setText(this.jRadioButtonAufloesungHd.getText() + "   [ " + this.dateiGroesse_HD + " MB ]");
            }
        }
        this.dateiGroesse_Hoch = this.datenFilm.getDateigroesse(this.datenFilm.getUrl());
        if (!this.dateiGroesse_Hoch.isEmpty()) {
            this.jRadioButtonAufloesungHoch.setText(this.jRadioButtonAufloesungHoch.getText() + "   [ " + this.dateiGroesse_Hoch + " MB ]");
        }
        if (this.jRadioButtonAufloesungKlein.isEnabled()) {
            this.dateiGroesse_Klein = this.datenFilm.getDateigroesse(this.datenFilm.getUrlFuerAufloesung("klein"));
            if (!this.dateiGroesse_Klein.isEmpty()) {
                this.jRadioButtonAufloesungKlein.setText(this.jRadioButtonAufloesungKlein.getText() + "   [ " + this.dateiGroesse_Klein + " MB ]");
            }
        }
        this.jButtonDelHistory.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD__PFADE_ZUM_SPEICHERN, "");
            this.jComboBoxPfad.setModel(new DefaultComboBoxModel<String>(new String[]{this.orgPfad}));
        });
        this.jCheckBoxPfadSpeichern.setSelected(this.config.getBoolean("download.path.last_used.show", true));
        this.jCheckBoxPfadSpeichern.addActionListener(e -> this.config.setProperty("download.path.last_used.show", this.jCheckBoxPfadSpeichern.isSelected()));
        this.setupResolutionButtons();
        this.calculateAndCheckDiskSpace();
        this.nameGeaendert = false;
    }

    private void setNameFilm() {
        if (!this.nameGeaendert) {
            this.stopBeob = true;
            this.datenDownload = new DatenDownload(this.pSet, this.datenFilm, 2, null, "", "", this.getFilmResolution());
            if (this.datenDownload.arr[29].isEmpty()) {
                this.jTextFieldName.setEnabled(false);
                this.jComboBoxPfad.setEnabled(false);
                this.jButtonZiel.setEnabled(false);
                this.jTextFieldName.setText("");
                this.jComboBoxPfad.setModel(new DefaultComboBoxModel<String>(new String[]{""}));
            } else {
                this.jTextFieldName.setEnabled(true);
                this.jComboBoxPfad.setEnabled(true);
                this.jButtonZiel.setEnabled(true);
                this.jTextFieldName.setText(this.datenDownload.arr[29]);
                DialogAddDownload.setModelPfad(this.datenDownload.arr[30], this.jComboBoxPfad);
                this.orgPfad = this.datenDownload.arr[30];
            }
            this.stopBeob = false;
        }
    }

    private long getFreeDiskSpace(String strPath) {
        long usableSpace = 0L;
        if (!strPath.isEmpty()) {
            try {
                Path path = Paths.get(strPath, new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    path = path.getParent();
                }
                FileStore fileStore = Files.getFileStore(path);
                usableSpace = fileStore.getUsableSpace();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return usableSpace;
    }

    private void calculateAndCheckDiskSpace() {
        this.jRadioButtonAufloesungHd.setForeground(Color.black);
        this.jRadioButtonAufloesungHoch.setForeground(Color.black);
        this.jRadioButtonAufloesungKlein.setForeground(Color.black);
        try {
            long usableSpace = this.getFreeDiskSpace(this.cbPathTextComponent.getText());
            if (usableSpace > 0L) {
                this.filmBorder.setTitle("Download-Qualit\u00e4t [ Freier Speicherplatz: " + ByteUnitUtil.byteCountToDisplaySize(usableSpace) + " ]");
            } else {
                this.filmBorder.setTitle(TITLED_BORDER_STRING);
            }
            this.jPanelSize.repaint();
            if ((usableSpace /= 1000000L) > 0L) {
                int size;
                if (!this.dateiGroesse_HD.isEmpty() && (long)(size = Integer.parseInt(this.dateiGroesse_HD)) > usableSpace) {
                    this.jRadioButtonAufloesungHd.setForeground(Color.red);
                }
                if (!this.dateiGroesse_Hoch.isEmpty() && (long)(size = Integer.parseInt(this.dateiGroesse_Hoch)) > usableSpace) {
                    this.jRadioButtonAufloesungHoch.setForeground(Color.red);
                }
                if (!this.dateiGroesse_Klein.isEmpty() && (long)(size = Integer.parseInt(this.dateiGroesse_Klein)) > usableSpace) {
                    this.jRadioButtonAufloesungKlein.setForeground(Color.red);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setModelPfad(String pfad, JComboBox<String> jcb) {
        ArrayList<String> pfade = new ArrayList<String>();
        boolean showLastUsedPath = ApplicationConfiguration.getConfiguration().getBoolean("download.path.last_used.show", true);
        if (!showLastUsedPath && !pfad.isEmpty()) {
            pfade.add(pfad);
        }
        if (!MVConfig.get(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD__PFADE_ZUM_SPEICHERN).isEmpty()) {
            String[] p;
            for (String s2 : p = MVConfig.get(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD__PFADE_ZUM_SPEICHERN).split("<>")) {
                if (pfade.contains(s2)) continue;
                pfade.add(s2);
            }
        }
        if (showLastUsedPath && !pfad.isEmpty() && !pfade.contains(pfad)) {
            pfade.add(pfad);
        }
        jcb.setModel(new DefaultComboBoxModel<String>(pfade.toArray(new String[0])));
    }

    public static void saveComboPfad(JComboBox<String> jcb, String orgPath) {
        int i;
        ArrayList<String> pfade = new ArrayList<String>();
        Object s2 = Objects.requireNonNull(jcb.getSelectedItem()).toString();
        if (!((String)s2).equals(orgPath) || ApplicationConfiguration.getConfiguration().getBoolean("download.path.last_used.show", true)) {
            pfade.add((String)s2);
        }
        for (i = 0; i < jcb.getItemCount(); ++i) {
            s2 = jcb.getItemAt(i);
            if (((String)s2).equals(orgPath) || pfade.contains(s2)) continue;
            pfade.add((String)s2);
        }
        if (!pfade.isEmpty()) {
            s2 = (String)pfade.get(0);
            for (i = 1; i < 15 && i < pfade.size(); ++i) {
                if (((String)pfade.get(i)).isEmpty()) continue;
                s2 = (String)s2 + "<>" + (String)pfade.get(i);
            }
        }
        MVConfig.add(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD__PFADE_ZUM_SPEICHERN, (String)s2);
    }

    private void setupResolutionButtons() {
        this.pSet = (DatenPset)Daten.listePset.getListeSpeichern().get(this.jComboBoxPset.getSelectedIndex());
        if (this.aufloesung.equals("hd") || this.pSet.arr[15].equals("hd") && !this.datenFilm.getHighQualityUrl().isEmpty()) {
            this.jRadioButtonAufloesungHd.setSelected(true);
        } else if (this.pSet.arr[15].equals("klein") && !this.datenFilm.getUrlKlein().isEmpty()) {
            this.jRadioButtonAufloesungKlein.setSelected(true);
        } else {
            this.jRadioButtonAufloesungHoch.setSelected(true);
        }
        this.jCheckBoxInfodatei.setSelected(Boolean.parseBoolean(this.pSet.arr[19]));
        if (this.datenFilm.getUrlSubtitle().isEmpty()) {
            this.jCheckBoxSubtitle.setEnabled(false);
        } else {
            this.jCheckBoxSubtitle.setSelected(Boolean.parseBoolean(this.pSet.arr[21]));
        }
        this.setNameFilm();
    }

    private String getFilmResolution() {
        if (this.jRadioButtonAufloesungHd.isSelected()) {
            return "hd";
        }
        if (this.jRadioButtonAufloesungKlein.isSelected()) {
            return "klein";
        }
        return "normal";
    }

    private String getFilmSize() {
        if (this.jRadioButtonAufloesungHd.isSelected()) {
            return this.dateiGroesse_HD;
        }
        if (this.jRadioButtonAufloesungKlein.isSelected()) {
            return this.dateiGroesse_Klein;
        }
        return this.dateiGroesse_Hoch;
    }

    private boolean check() {
        this.ok = false;
        Object pfad = Objects.requireNonNull(this.jComboBoxPfad.getSelectedItem()).toString();
        String name = this.jTextFieldName.getText();
        if (this.datenDownload != null) {
            if (((String)pfad).isEmpty() || name.isEmpty()) {
                MVMessageDialog.showMessageDialog(this, "Pfad oder Name ist leer", "Fehlerhafter Pfad/Name!", 0);
            } else {
                if (!((String)pfad).substring(((String)pfad).length() - 1).equals(File.separator)) {
                    pfad = (String)pfad + File.separator;
                }
                if (GuiFunktionenProgramme.checkPathWriteable((String)pfad)) {
                    this.ok = true;
                } else {
                    MVMessageDialog.showMessageDialog(this, "Pfad ist nicht beschreibbar", "Fehlerhafter Pfad!", 0);
                }
            }
        }
        return this.ok;
    }

    private void beenden() {
        if (this.ok) {
            this.datenDownload = new DatenDownload(this.pSet, this.datenFilm, 2, null, this.jTextFieldName.getText(), Objects.requireNonNull(this.jComboBoxPfad.getSelectedItem()).toString(), this.getFilmResolution());
            this.datenDownload.setGroesse(this.getFilmSize());
            this.datenDownload.arr[35] = Boolean.toString(this.jCheckBoxInfodatei.isSelected());
            this.datenDownload.arr[37] = Boolean.toString(this.jCheckBoxSubtitle.isSelected());
            this.daten.getListeDownloads().addMitNummer(this.datenDownload);
            this.daten.getMessageBus().publishAsync(new DownloadListChangedEvent());
            if (this.jCheckBoxStarten.isSelected()) {
                this.datenDownload.startDownload(this.daten);
            }
        }
        DialogAddDownload.saveComboPfad(this.jComboBoxPfad, this.orgPfad);
        this.dispose();
    }

    private void initComponents() {
        ButtonGroup buttonGroup1 = new ButtonGroup();
        this.jButtonOk = new JButton();
        this.jButtonAbbrechen = new JButton();
        this.jCheckBoxStarten = new JCheckBox();
        JPanel jPanel1 = new JPanel();
        this.jTextFieldName = new JTextField();
        this.jButtonZiel = new JButton();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.jComboBoxPfad = new JComboBox();
        this.jButtonDelHistory = new JButton();
        this.jCheckBoxPfadSpeichern = new JCheckBox();
        this.jCheckBoxInfodatei = new JCheckBox();
        this.jLabelSet = new JLabel();
        this.jComboBoxPset = new JComboBox();
        this.jCheckBoxSubtitle = new JCheckBox();
        this.jPanelSize = new JPanel();
        this.jRadioButtonAufloesungHd = new JRadioButton();
        this.jRadioButtonAufloesungHoch = new JRadioButton();
        this.jRadioButtonAufloesungKlein = new JRadioButton();
        this.jTextFieldSender = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Film speichern");
        this.setMinimumSize(new Dimension(646, 372));
        this.jButtonOk.setText("Ok");
        this.jButtonAbbrechen.setText("Abbrechen");
        this.jCheckBoxStarten.setSelected(true);
        this.jCheckBoxStarten.setText("Download sofort starten");
        this.jButtonZiel.setText("File");
        this.jButtonZiel.setToolTipText("Zielpfad ausw\u00e4hlen");
        jLabel1.setText("Zielpfad:");
        jLabel4.setText("Dateiname:");
        this.jComboBoxPfad.setEditable(true);
        this.jComboBoxPfad.setMaximumRowCount(15);
        this.jButtonDelHistory.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-del.png")));
        this.jButtonDelHistory.setToolTipText("History l\u00f6schen");
        this.jCheckBoxPfadSpeichern.setText("Zielpfad speichern");
        this.jCheckBoxInfodatei.setText("Infodatei anlegen: \"Filmname.txt\"");
        this.jLabelSet.setText("Set:");
        this.jCheckBoxSubtitle.setText("Untertitel speichern: \"Filmname.xxx\"");
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelSet).addComponent(jLabel1)).addGap(30, 30, 30).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jComboBoxPfad, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonZiel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelHistory)).addComponent(this.jComboBoxPset, 0, -1, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxSubtitle).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxInfodatei).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 155, Short.MAX_VALUE).addComponent(this.jCheckBoxPfadSpeichern)).addComponent(this.jTextFieldName)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelSet).addComponent(this.jComboBoxPset, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel1).addComponent(this.jButtonZiel).addComponent(this.jComboBoxPfad, -2, -1, -2).addComponent(this.jButtonDelHistory)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel4).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxPfadSpeichern).addComponent(this.jCheckBoxInfodatei)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxSubtitle).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jButtonZiel, this.jTextFieldName);
        this.jPanelSize.setBorder(BorderFactory.createTitledBorder(TITLED_BORDER_STRING));
        buttonGroup1.add(this.jRadioButtonAufloesungHd);
        this.jRadioButtonAufloesungHd.setText("H\u00f6chste/Hoch");
        buttonGroup1.add(this.jRadioButtonAufloesungHoch);
        this.jRadioButtonAufloesungHoch.setText("Mittel");
        buttonGroup1.add(this.jRadioButtonAufloesungKlein);
        this.jRadioButtonAufloesungKlein.setText("Niedrig");
        GroupLayout jPanelSizeLayout = new GroupLayout(this.jPanelSize);
        this.jPanelSize.setLayout(jPanelSizeLayout);
        jPanelSizeLayout.setHorizontalGroup(jPanelSizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSizeLayout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonAufloesungHd).addGap(18, 18, 18).addComponent(this.jRadioButtonAufloesungHoch).addGap(18, 18, 18).addComponent(this.jRadioButtonAufloesungKlein).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelSizeLayout.setVerticalGroup(jPanelSizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSizeLayout.createSequentialGroup().addContainerGap().addGroup(jPanelSizeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonAufloesungHd).addComponent(this.jRadioButtonAufloesungHoch).addComponent(this.jRadioButtonAufloesungKlein)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTextFieldSender.setEditable(false);
        this.jTextFieldSender.setFont(new Font("Dialog", 1, 12));
        this.jTextFieldSender.setText(" ARD: Tatort, ...");
        this.jTextFieldSender.setBorder(BorderFactory.createTitledBorder("Film"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelSize, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxStarten).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOk, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAbbrechen)).addComponent(this.jTextFieldSender)).addContainerGap()));
        layout.linkSize(0, this.jButtonAbbrechen, this.jButtonOk);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTextFieldSender, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOk).addComponent(this.jButtonAbbrechen)).addComponent(this.jCheckBoxStarten)).addContainerGap()));
        this.pack();
    }

    private class ZielBeobachter
    implements ActionListener {
        private ZielBeobachter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemUtils.IS_OS_MAC_OSX) {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                FileDialog chooser = new FileDialog((Frame)MediathekGui.ui(), "Film speichern");
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        DialogAddDownload.this.jComboBoxPfad.addItem(chooser.getDirectory() + chooser.getFile());
                        DialogAddDownload.this.jComboBoxPfad.setSelectedItem(chooser.getDirectory() + chooser.getFile());
                    }
                    catch (Exception ex) {
                        Log.errorLog(356871087, ex);
                    }
                }
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            } else {
                JFileChooser chooser = new JFileChooser();
                if (!Objects.requireNonNull(DialogAddDownload.this.jComboBoxPfad.getSelectedItem()).toString().isEmpty()) {
                    chooser.setCurrentDirectory(new File(DialogAddDownload.this.jComboBoxPfad.getSelectedItem().toString()));
                }
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        DialogAddDownload.this.jComboBoxPfad.addItem(chooser.getSelectedFile().getAbsolutePath());
                        DialogAddDownload.this.jComboBoxPfad.setSelectedItem(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.errorLog(356871087, ex);
                    }
                }
            }
        }
    }

    private class BeobRadio
    implements ActionListener {
        private BeobRadio() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogAddDownload.this.setNameFilm();
        }
    }
}

