/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.process.AbstractTokenizer;
import edu.stanford.nlp.process.LexedTokenFactory;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.process.WhitespaceLexer;
import edu.stanford.nlp.process.WordTokenFactory;
import edu.stanford.nlp.util.StringUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhitespaceTokenizer<T extends HasWord>
extends AbstractTokenizer<T> {
    private WhitespaceLexer lexer;
    private final boolean eolIsSignificant;

    @Override
    protected T getNext() {
        HasWord token = null;
        if (this.lexer == null) {
            return (T)token;
        }
        try {
            token = (HasWord)this.lexer.next();
            while (token != null && token.word().equals("\n")) {
                if (this.eolIsSignificant) {
                    return (T)token;
                }
                token = (HasWord)this.lexer.next();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (T)token;
    }

    public WhitespaceTokenizer(LexedTokenFactory factory, Reader r) {
        this(factory, r, false);
    }

    public WhitespaceTokenizer(LexedTokenFactory factory, Reader r, boolean eolIsSignificant) {
        this.eolIsSignificant = eolIsSignificant;
        if (r != null) {
            this.lexer = new WhitespaceLexer(r, factory);
        }
    }

    public static WhitespaceTokenizer<Word> newWordWhitespaceTokenizer(Reader r) {
        return WhitespaceTokenizer.newWordWhitespaceTokenizer(r, false);
    }

    public static WhitespaceTokenizer<Word> newWordWhitespaceTokenizer(Reader r, boolean eolIsSignificant) {
        return new WhitespaceTokenizer<Word>(new WordTokenFactory(), r, eolIsSignificant);
    }

    public static TokenizerFactory<Word> factory() {
        return new WhitespaceTokenizerFactory<Word>(new WordTokenFactory(), false);
    }

    public static TokenizerFactory<Word> factory(boolean eolIsSignificant) {
        return new WhitespaceTokenizerFactory<Word>(new WordTokenFactory(), eolIsSignificant);
    }

    public static void main(String[] args) throws IOException {
        boolean eolIsSignificant = args.length > 0 && args[0].equals("-cr");
        InputStreamReader reader = args.length > 0 && !args[args.length - 1].equals("-cr") ? new InputStreamReader((InputStream)new FileInputStream(args[args.length - 1]), "UTF-8") : new InputStreamReader(System.in, "UTF-8");
        WhitespaceTokenizer tokenizer = new WhitespaceTokenizer(new WordTokenFactory(), reader, eolIsSignificant);
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "UTF-8"), true);
        while (tokenizer.hasNext()) {
            Word w = (Word)tokenizer.next();
            if (w.value().equals("\n")) {
                pw.println("***CR***");
                continue;
            }
            pw.println(w);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WhitespaceTokenizerFactory<T extends HasWord>
    implements TokenizerFactory<T> {
        private boolean tokenizeNLs;
        private LexedTokenFactory<T> factory;

        public static TokenizerFactory<Word> newTokenizerFactory() {
            return new WhitespaceTokenizerFactory<Word>(new WordTokenFactory(), false);
        }

        public WhitespaceTokenizerFactory(LexedTokenFactory<T> factory) {
            this(factory, false);
        }

        public WhitespaceTokenizerFactory(LexedTokenFactory<T> factory, boolean tokenizeNLs) {
            this.factory = factory;
            this.tokenizeNLs = tokenizeNLs;
        }

        @Override
        public Iterator<T> getIterator(Reader r) {
            return this.getTokenizer(r);
        }

        @Override
        public Tokenizer<T> getTokenizer(Reader r) {
            return new WhitespaceTokenizer(this.factory, r, this.tokenizeNLs);
        }

        @Override
        public void setOptions(String options) {
            Properties prop = StringUtils.stringToProperties(options);
            for (Map.Entry<Object, Object> item : prop.entrySet()) {
                String key = (String)item.getKey();
                String value = (String)item.getValue();
                boolean val = Boolean.valueOf(value);
                if (!key.equals("tokenizeNLs")) continue;
                this.tokenizeNLs = val;
            }
        }
    }
}

