/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.spi;

import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.renderable.RedRable;
import io.sf.carte.echosvg.ext.awt.image.spi.AbstractBrokenLinkProvider;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Hashtable;

public class DefaultBrokenLinkProvider
extends AbstractBrokenLinkProvider {
    private static final Color BROKEN_LINK_COLOR = new Color(255, 255, 255, 190);

    @Override
    public Filter getBrokenLinkImage(Object base, String code, Object[] params) {
        BufferedImage bi = new BufferedImage(100, 100, 2);
        String message = DefaultBrokenLinkProvider.formatMessage(base, code, params);
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("io.sf.carte.echosvg.BrokenLinkImage", message);
        bi = new BufferedImage(bi.getColorModel(), bi.getRaster(), bi.isAlphaPremultiplied(), ht);
        Graphics2D g2d = bi.createGraphics();
        g2d.setColor(BROKEN_LINK_COLOR);
        g2d.fillRect(0, 0, 100, 100);
        g2d.setColor(Color.black);
        g2d.drawRect(2, 2, 96, 96);
        Font hdrfont = new Font("SansSerif", 1, 16);
        g2d.setFont(hdrfont);
        g2d.drawString("Broken Image", 6, 30);
        Font font = new Font("Serif", 0, 10);
        g2d.setFont(font);
        g2d.drawString(message, 5, 60);
        g2d.dispose();
        return new RedRable(GraphicsUtil.wrap(bi));
    }
}

