/*
 * Decompiled with CFR 0.152.
 */
package waffle.windows.auth.impl;

import com.sun.jna.platform.win32.Secur32;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.Win32Exception;
import waffle.windows.auth.IWindowsCredentialsHandle;

public class WindowsCredentialsHandleImpl
implements IWindowsCredentialsHandle {
    private final String principalName;
    private final int credentialsType;
    private final String securityPackage;
    private Sspi.CredHandle handle;

    public WindowsCredentialsHandleImpl(String newPrincipalName, int newCredentialsType, String newSecurityPackage) {
        this.principalName = newPrincipalName;
        this.credentialsType = newCredentialsType;
        this.securityPackage = newSecurityPackage;
    }

    public static IWindowsCredentialsHandle getCurrent(String securityPackage) {
        WindowsCredentialsHandleImpl handle = new WindowsCredentialsHandleImpl(null, 2, securityPackage);
        handle.initialize();
        return handle;
    }

    @Override
    public void initialize() {
        this.handle = new Sspi.CredHandle();
        Sspi.TimeStamp clientLifetime = new Sspi.TimeStamp();
        int rc = Secur32.INSTANCE.AcquireCredentialsHandle(this.principalName, this.securityPackage, this.credentialsType, null, null, null, null, this.handle, clientLifetime);
        if (0 != rc) {
            throw new Win32Exception(rc);
        }
    }

    @Override
    public void dispose() {
        int rc;
        if (this.handle != null && !this.handle.isNull() && 0 != (rc = Secur32.INSTANCE.FreeCredentialsHandle(this.handle))) {
            throw new Win32Exception(rc);
        }
    }

    @Override
    public Sspi.CredHandle getHandle() {
        return this.handle;
    }
}

