/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.authenticators.util.AuthenticatorUtils;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.ExchangeExternalToken;
import org.keycloak.broker.provider.ExchangeTokenToIdentityProviderToken;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderMapper;
import org.keycloak.broker.provider.IdentityProviderMapperSyncModeDelegate;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Base64Url;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.ImpersonationSessionNote;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.light.LightweightUserAdapter;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.TokenExchangeContext;
import org.keycloak.protocol.oidc.TokenExchangeProvider;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.endpoints.TokenEndpoint;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.protocol.saml.SamlProtocol;
import org.keycloak.protocol.saml.SamlService;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.saml.common.constants.GeneralConstants;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.Urls;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.services.validation.Validation;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.util.TokenUtil;

public class DefaultTokenExchangeProvider
implements TokenExchangeProvider {
    private static final Logger logger = Logger.getLogger(DefaultTokenExchangeProvider.class);
    private TokenExchangeContext.Params params;
    private MultivaluedMap<String, String> formParams;
    private KeycloakSession session;
    private Cors cors;
    private RealmModel realm;
    private ClientModel client;
    private EventBuilder event;
    private ClientConnection clientConnection;
    private HttpHeaders headers;
    private TokenManager tokenManager;
    private Map<String, String> clientAuthAttributes;

    public boolean supports(TokenExchangeContext context) {
        return true;
    }

    public Response exchange(TokenExchangeContext context) {
        this.params = context.getParams();
        this.formParams = context.getFormParams();
        this.session = context.getSession();
        this.cors = context.getCors();
        this.realm = context.getRealm();
        this.client = context.getClient();
        this.event = context.getEvent();
        this.clientConnection = context.getClientConnection();
        this.headers = context.getHeaders();
        this.tokenManager = (TokenManager)context.getTokenManager();
        this.clientAuthAttributes = context.getClientAuthAttributes();
        return this.tokenExchange();
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response tokenExchange() {
        String requestedIssuer;
        UserModel tokenUser = null;
        UserSessionModel tokenSession = null;
        AccessToken token = null;
        String subjectToken = (String)this.formParams.getFirst((Object)"subject_token");
        if (subjectToken != null) {
            String subjectTokenType = (String)this.formParams.getFirst((Object)"subject_token_type");
            String realmIssuerUrl = Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName());
            String subjectIssuer = (String)this.formParams.getFirst((Object)"subject_issuer");
            if (subjectIssuer == null && "urn:ietf:params:oauth:token-type:jwt".equals(subjectTokenType)) {
                try {
                    JWSInput jws = new JWSInput(subjectToken);
                    JsonWebToken jwt = (JsonWebToken)jws.readJsonContent(JsonWebToken.class);
                    subjectIssuer = jwt.getIssuer();
                }
                catch (JWSInputException e) {
                    this.event.detail("reason", "unable to parse jwt subject_token");
                    this.event.error("invalid_token");
                    throw new CorsErrorResponseException(this.cors, "invalid_request", "Invalid token type, must be access token", Response.Status.BAD_REQUEST);
                }
            }
            if (subjectIssuer != null && !realmIssuerUrl.equals(subjectIssuer)) {
                this.event.detail("subject_issuer", subjectIssuer);
                return this.exchangeExternalToken(subjectIssuer, subjectToken);
            }
            if (subjectTokenType != null && !subjectTokenType.equals("urn:ietf:params:oauth:token-type:access_token")) {
                this.event.detail("reason", "subject_token supports access tokens only");
                this.event.error("invalid_token");
                throw new CorsErrorResponseException(this.cors, "invalid_request", "Invalid token type, must be access token", Response.Status.BAD_REQUEST);
            }
            AuthenticationManager.AuthResult authResult = AuthenticationManager.verifyIdentityToken(this.session, this.realm, (UriInfo)this.session.getContext().getUri(), this.clientConnection, true, true, null, false, subjectToken, this.headers, new TokenVerifier.Predicate[0]);
            if (authResult == null) {
                this.event.detail("reason", "subject_token validation failure");
                this.event.error("invalid_token");
                throw new CorsErrorResponseException(this.cors, "invalid_request", "Invalid token", Response.Status.BAD_REQUEST);
            }
            tokenUser = authResult.getUser();
            tokenSession = authResult.getSession();
            token = authResult.getToken();
        }
        String requestedSubject = (String)this.formParams.getFirst((Object)"requested_subject");
        boolean disallowOnHolderOfTokenMismatch = true;
        if (requestedSubject != null) {
            this.event.detail("requested_subject", requestedSubject);
            UserModel requestedUser = this.session.users().getUserByUsername(this.realm, requestedSubject);
            if (requestedUser == null) {
                requestedUser = this.session.users().getUserById(this.realm, requestedSubject);
            }
            if (requestedUser == null) {
                this.event.detail("reason", "requested_subject not found");
                this.event.error("not_allowed");
                throw new CorsErrorResponseException(this.cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
            }
            if (token != null) {
                this.event.detail("impersonator", tokenUser.getUsername());
                AdminAuth auth = new AdminAuth(this.realm, token, tokenUser, this.client);
                if (!AdminPermissions.evaluator(this.session, this.realm, auth).users().canImpersonate(requestedUser, this.client)) {
                    this.event.detail("reason", "subject not allowed to impersonate");
                    this.event.error("not_allowed");
                    throw new CorsErrorResponseException(this.cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
                }
            } else {
                if (this.client.isPublicClient()) {
                    this.event.detail("reason", "public clients not allowed");
                    this.event.error("not_allowed");
                    throw new CorsErrorResponseException(this.cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
                }
                if (!AdminPermissions.management(this.session, this.realm).users().canClientImpersonate(this.client, requestedUser)) {
                    this.event.detail("reason", "client not allowed to impersonate");
                    this.event.error("not_allowed");
                    throw new CorsErrorResponseException(this.cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
                }
                disallowOnHolderOfTokenMismatch = false;
            }
            tokenSession = new UserSessionManager(this.session).createUserSession(this.realm, requestedUser, requestedUser.getUsername(), this.clientConnection.getRemoteAddr(), "impersonate", false, null, null);
            if (tokenUser != null) {
                tokenSession.setNote(ImpersonationSessionNote.IMPERSONATOR_ID.toString(), tokenUser.getId());
                tokenSession.setNote(ImpersonationSessionNote.IMPERSONATOR_USERNAME.toString(), tokenUser.getUsername());
            }
            tokenUser = requestedUser;
        }
        if ((requestedIssuer = (String)this.formParams.getFirst((Object)"requested_issuer")) == null) {
            return this.exchangeClientToClient(tokenUser, tokenSession, token, disallowOnHolderOfTokenMismatch);
        }
        try {
            Response response = this.exchangeToIdentityProvider(tokenUser, tokenSession, requestedIssuer);
            return response;
        }
        finally {
            if (subjectToken == null) {
                try {
                    this.session.sessions().removeUserSession(this.realm, tokenSession);
                }
                catch (Exception exception) {}
            }
        }
    }

    protected Response exchangeToIdentityProvider(UserModel targetUser, UserSessionModel targetUserSession, String requestedIssuer) {
        this.event.detail("requested_issuer", requestedIssuer);
        IdentityProviderModel providerModel = this.session.identityProviders().getByAlias(requestedIssuer);
        if (providerModel == null) {
            this.event.detail("reason", "unknown requested_issuer");
            this.event.error("unknown_identity_provider");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Invalid issuer", Response.Status.BAD_REQUEST);
        }
        IdentityProvider<?> provider = IdentityBrokerService.getIdentityProvider(this.session, requestedIssuer);
        if (!(provider instanceof ExchangeTokenToIdentityProviderToken)) {
            this.event.detail("reason", "exchange unsupported by requested_issuer");
            this.event.error("unknown_identity_provider");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Issuer does not support token exchange", Response.Status.BAD_REQUEST);
        }
        if (!AdminPermissions.management(this.session, this.realm).idps().canExchangeTo(this.client, providerModel)) {
            this.event.detail("reason", "client not allowed to exchange for requested_issuer");
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
        }
        Response response = ((ExchangeTokenToIdentityProviderToken)provider).exchangeFromToken((UriInfo)this.session.getContext().getUri(), this.event, this.client, targetUserSession, targetUser, this.formParams);
        return this.cors.add(Response.fromResponse((Response)response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Response exchangeClientToClient(UserModel targetUser, UserSessionModel targetUserSession, AccessToken token, boolean disallowOnHolderOfTokenMismatch) {
        String requestedTokenType = (String)this.formParams.getFirst((Object)"requested_token_type");
        if (requestedTokenType == null) {
            requestedTokenType = "urn:ietf:params:oauth:token-type:refresh_token";
        } else if (!(requestedTokenType.equals("urn:ietf:params:oauth:token-type:access_token") || requestedTokenType.equals("urn:ietf:params:oauth:token-type:refresh_token") || requestedTokenType.equals("urn:ietf:params:oauth:token-type:saml2"))) {
            this.event.detail("reason", "requested_token_type unsupported");
            this.event.error("invalid_request");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "requested_token_type unsupported", Response.Status.BAD_REQUEST);
        }
        List audienceParams = this.params.getAudience();
        ClientModel tokenHolder = token == null ? null : this.realm.getClientByClientId(token.getIssuedFor());
        ArrayList<ClientModel> targetAudienceClients = new ArrayList<ClientModel>();
        if (audienceParams != null) {
            for (String audience : audienceParams) {
                ClientModel targetClient = this.realm.getClientByClientId(audience);
                if (targetClient == null) {
                    this.event.detail("reason", "audience not found");
                    this.event.detail("audience", audience);
                    this.event.error("client_not_found");
                    throw new CorsErrorResponseException(this.cors, "invalid_client", "Audience not found", Response.Status.BAD_REQUEST);
                }
                targetAudienceClients.add(targetClient);
            }
        }
        for (ClientModel targetClient : targetAudienceClients) {
            if (targetClient.isConsentRequired()) {
                this.event.detail("reason", "audience requires consent");
                this.event.detail("audience", targetClient.getClientId());
                this.event.error("consent_denied");
                throw new CorsErrorResponseException(this.cors, "invalid_client", "Client requires user consent", Response.Status.BAD_REQUEST);
            }
            if (targetClient.isEnabled()) continue;
            this.event.detail("reason", "audience client disabled");
            this.event.detail("audience", targetClient.getClientId());
            this.event.error("client_disabled");
            throw new CorsErrorResponseException(this.cors, "invalid_client", "Client disabled", Response.Status.BAD_REQUEST);
        }
        if (targetAudienceClients.isEmpty()) {
            targetAudienceClients.add(this.client);
        }
        for (ClientModel targetClient : targetAudienceClients) {
            boolean isClientTheAudience = targetClient.equals((Object)this.client);
            if (isClientTheAudience) {
                if (this.client.isPublicClient()) {
                    this.forbiddenIfClientIsNotTokenHolder(disallowOnHolderOfTokenMismatch, tokenHolder);
                    continue;
                }
                if (this.client.equals((Object)tokenHolder)) continue;
                this.forbiddenIfClientIsNotWithinTokenAudience(token, tokenHolder);
                continue;
            }
            if (this.client.isPublicClient()) {
                this.forbiddenIfClientIsNotTokenHolder(disallowOnHolderOfTokenMismatch, tokenHolder);
            }
            if (AdminPermissions.management(this.session, this.realm).clients().canExchangeTo(this.client, targetClient, token)) continue;
            this.event.detail("reason", "client not allowed to exchange to audience");
            this.event.detail("audience", targetClient.getClientId());
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
        }
        ClientModel targetClient = (ClientModel)targetAudienceClients.get(0);
        if (targetAudienceClients.size() > 1) {
            logger.warnf("Only one value of audience parameter currently supported for token exchange. Using audience '%s' and ignoring the other audiences provided", (Object)targetClient.getClientId());
        }
        String scope = (String)this.formParams.getFirst((Object)"scope");
        if (token != null && token.getScope() != null && scope == null) {
            scope = token.getScope();
            HashSet targetClientScopes = new HashSet();
            targetClientScopes.addAll(targetClient.getClientScopes(true).keySet());
            targetClientScopes.addAll(targetClient.getClientScopes(false).keySet());
            scope = Arrays.stream(scope.split(" ")).filter(s -> "openid".equals(s) || targetClientScopes.contains(Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DYNAMIC_SCOPES) ? s.split(":")[0] : s)).collect(Collectors.joining(" "));
        } else if (token != null && token.getScope() != null) {
            String subjectTokenScopes = token.getScope();
            if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DYNAMIC_SCOPES)) {
                subjectTokenScopesSet = Arrays.stream(subjectTokenScopes.split(" ")).map(s -> s.split(":")[0]).collect(Collectors.toSet());
                scope = Arrays.stream(scope.split(" ")).filter(sc -> subjectTokenScopesSet.contains(sc.split(":")[0])).collect(Collectors.joining(" "));
            } else {
                subjectTokenScopesSet = Arrays.stream(subjectTokenScopes.split(" ")).collect(Collectors.toSet());
                scope = Arrays.stream(scope.split(" ")).filter(sc -> subjectTokenScopesSet.contains(sc)).collect(Collectors.joining(" "));
            }
            HashSet targetClientScopes = new HashSet();
            targetClientScopes.addAll(targetClient.getClientScopes(true).keySet());
            targetClientScopes.addAll(targetClient.getClientScopes(false).keySet());
            scope = Arrays.stream(scope.split(" ")).filter(s -> "openid".equals(s) || targetClientScopes.contains(Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DYNAMIC_SCOPES) ? s.split(":")[0] : s)).collect(Collectors.joining(" "));
        }
        try {
            this.session.getContext().setClient(targetClient);
            switch (requestedTokenType) {
                case "urn:ietf:params:oauth:token-type:access_token": 
                case "urn:ietf:params:oauth:token-type:refresh_token": {
                    Response response = this.exchangeClientToOIDCClient(targetUser, targetUserSession, requestedTokenType, targetClient, scope);
                    return response;
                }
                case "urn:ietf:params:oauth:token-type:saml2": {
                    Response response = this.exchangeClientToSAML2Client(targetUser, targetUserSession, requestedTokenType, targetClient);
                    return response;
                }
            }
            throw new CorsErrorResponseException(this.cors, "invalid_request", "requested_token_type unsupported", Response.Status.BAD_REQUEST);
        }
        finally {
            this.session.getContext().setClient(this.client);
        }
    }

    private void forbiddenIfClientIsNotWithinTokenAudience(AccessToken token, ClientModel tokenHolder) {
        if (token != null && !token.hasAudience(this.client.getClientId())) {
            this.event.detail("reason", "client is not within the token audience");
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "access_denied", "Client is not within the token audience", Response.Status.FORBIDDEN);
        }
    }

    private void forbiddenIfClientIsNotTokenHolder(boolean disallowOnHolderOfTokenMismatch, ClientModel tokenHolder) {
        if (disallowOnHolderOfTokenMismatch && !this.client.equals((Object)tokenHolder)) {
            this.event.detail("reason", "client is not the token holder");
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "access_denied", "Client is not the holder of the token", Response.Status.FORBIDDEN);
        }
    }

    private AuthenticationSessionModel createSessionModel(UserSessionModel targetUserSession, RootAuthenticationSessionModel rootAuthSession, UserModel targetUser, ClientModel client, String scope) {
        AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(client);
        authSession.setAuthenticatedUser(targetUser);
        authSession.setProtocol("openid-connect");
        authSession.setClientNote("iss", Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
        authSession.setClientNote("scope", scope);
        return authSession;
    }

    protected Response exchangeClientToOIDCClient(UserModel targetUser, UserSessionModel targetUserSession, String requestedTokenType, ClientModel targetClient, String scope) {
        String issuedTokenType;
        RootAuthenticationSessionModel rootAuthSession = new AuthenticationSessionManager(this.session).createAuthenticationSession(this.realm, false);
        AuthenticationSessionModel authSession = this.createSessionModel(targetUserSession, rootAuthSession, targetUser, targetClient, scope);
        if (targetUserSession == null) {
            targetUserSession = new UserSessionManager(this.session).createUserSession(authSession.getParentSession().getId(), this.realm, targetUser, targetUser.getUsername(), this.clientConnection.getRemoteAddr(), "client_auth", false, null, null, UserSessionModel.SessionPersistenceState.TRANSIENT);
        }
        this.event.session(targetUserSession);
        AuthenticationManager.setClientScopesInSession(this.session, authSession);
        ClientSessionContext clientSessionCtx = TokenManager.attachAuthenticationSession(this.session, targetUserSession, authSession);
        if (!AuthenticationManager.isClientSessionValid(this.realm, this.client, targetUserSession, targetUserSession.getAuthenticatedClientSessionByClient(this.client.getId()))) {
            AuthenticationSessionModel clientAuthSession = this.createSessionModel(targetUserSession, rootAuthSession, targetUser, this.client, scope);
            TokenManager.attachAuthenticationSession(this.session, targetUserSession, clientAuthSession);
        }
        this.updateUserSessionFromClientAuth(targetUserSession);
        TokenManager.AccessTokenResponseBuilder responseBuilder = this.tokenManager.responseBuilder(this.realm, targetClient, this.event, this.session, targetUserSession, clientSessionCtx).generateAccessToken();
        responseBuilder.getAccessToken().issuedFor(this.client.getClientId());
        if (targetClient != null && !targetClient.equals((Object)this.client)) {
            responseBuilder.getAccessToken().addAudience(targetClient.getClientId());
        }
        if (this.formParams.containsKey((Object)"requested_subject")) {
            targetUserSession.setNote(ImpersonationSessionNote.IMPERSONATOR_CLIENT.toString(), this.client.getId());
        }
        if (targetUserSession.getPersistenceState() == UserSessionModel.SessionPersistenceState.TRANSIENT) {
            responseBuilder.getAccessToken().setSessionId(null);
        }
        if (requestedTokenType.equals("urn:ietf:params:oauth:token-type:refresh_token") && OIDCAdvancedConfigWrapper.fromClientModel(this.client).isUseRefreshToken() && targetUserSession.getPersistenceState() != UserSessionModel.SessionPersistenceState.TRANSIENT) {
            responseBuilder.generateRefreshToken();
            responseBuilder.getRefreshToken().issuedFor(this.client.getClientId());
            issuedTokenType = "urn:ietf:params:oauth:token-type:refresh_token";
        } else {
            issuedTokenType = "urn:ietf:params:oauth:token-type:access_token";
        }
        String scopeParam = clientSessionCtx.getClientSession().getNote("scope");
        if (TokenUtil.isOIDCRequest((String)scopeParam)) {
            responseBuilder.generateIDToken().generateAccessTokenHash();
        }
        AccessTokenResponse res = responseBuilder.build();
        res.setOtherClaims("issued_token_type", (Object)issuedTokenType);
        this.event.detail("audience", targetClient.getClientId()).user(targetUser);
        this.event.success();
        return this.cors.add(Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    protected Response exchangeClientToSAML2Client(UserModel targetUser, UserSessionModel targetUserSession, String requestedTokenType, ClientModel targetClient) {
        LoginProtocolFactory factory = (LoginProtocolFactory)this.session.getKeycloakSessionFactory().getProviderFactory(LoginProtocol.class, "saml");
        SamlService samlService = (SamlService)factory.createProtocolEndpoint(this.session, this.event);
        AuthenticationSessionModel authSession = samlService.getOrCreateLoginSessionForIdpInitiatedSso(this.session, this.realm, targetClient, null);
        if (authSession == null) {
            logger.error((Object)"SAML assertion consumer url not set up");
            throw new CorsErrorResponseException(this.cors, "invalid_client", "Client requires assertion consumer url set up", Response.Status.BAD_REQUEST);
        }
        authSession.setAuthenticatedUser(targetUser);
        this.event.session(targetUserSession);
        AuthenticationManager.setClientScopesInSession(this.session, authSession);
        ClientSessionContext clientSessionCtx = TokenManager.attachAuthenticationSession(this.session, targetUserSession, authSession);
        this.updateUserSessionFromClientAuth(targetUserSession);
        SamlClient samlClient = new SamlClient(targetClient);
        SamlProtocol samlProtocol = new TokenEndpoint.TokenExchangeSamlProtocol(samlClient).setEventBuilder(this.event).setHttpHeaders(this.headers).setRealm(this.realm).setSession(this.session).setUriInfo((UriInfo)this.session.getContext().getUri());
        Response samlAssertion = samlProtocol.authenticated(authSession, targetUserSession, clientSessionCtx);
        if (samlAssertion.getStatus() != 200) {
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Can not get SAML 2.0 token", Response.Status.BAD_REQUEST);
        }
        String xmlString = (String)samlAssertion.getEntity();
        String encodedXML = Base64Url.encode((byte[])xmlString.getBytes(GeneralConstants.SAML_CHARSET));
        int assertionLifespan = samlClient.getAssertionLifespan();
        AccessTokenResponse res = new AccessTokenResponse();
        res.setToken(encodedXML);
        res.setTokenType("Bearer");
        res.setExpiresIn(assertionLifespan <= 0 ? (long)this.realm.getAccessCodeLifespan() : (long)assertionLifespan);
        res.setOtherClaims("issued_token_type", (Object)requestedTokenType);
        this.event.detail("audience", targetClient.getClientId()).user(targetUser);
        this.event.success();
        return this.cors.add(Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    protected Response exchangeExternalToken(String subjectIssuer, String subjectToken) {
        ExternalExchangeContext externalExchangeContext = this.locateExchangeExternalTokenByAlias(subjectIssuer);
        if (externalExchangeContext == null) {
            this.event.error("invalid_issuer");
            throw new CorsErrorResponseException(this.cors, "invalid_issuer", "Invalid subject_issuer parameter", Response.Status.BAD_REQUEST);
        }
        if (!AdminPermissions.management(this.session, this.realm).idps().canExchangeTo(this.client, externalExchangeContext.idpModel())) {
            this.event.detail("reason", "client not allowed to exchange subject_issuer");
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
        }
        BrokeredIdentityContext context = externalExchangeContext.provider().exchangeExternal(this.event, this.formParams);
        if (context == null) {
            this.event.error("invalid_issuer");
            throw new CorsErrorResponseException(this.cors, "invalid_issuer", "Invalid subject_issuer parameter", Response.Status.BAD_REQUEST);
        }
        UserModel user = this.importUserFromExternalIdentity(context);
        UserSessionModel userSession = new UserSessionManager(this.session).createUserSession(this.realm, user, user.getUsername(), this.clientConnection.getRemoteAddr(), "external-exchange", false, null, null);
        externalExchangeContext.provider().exchangeExternalComplete(userSession, context, this.formParams);
        userSession.setNote("EXTERNAL_IDENTITY_PROVIDER", externalExchangeContext.idpModel().getAlias());
        userSession.setNote("FEDERATED_ACCESS_TOKEN", subjectToken);
        context.addSessionNotesToUserSession(userSession);
        return this.exchangeClientToClient(user, userSession, null, false);
    }

    protected UserModel importUserFromExternalIdentity(BrokeredIdentityContext context) {
        IdentityProviderModel identityProviderConfig = context.getIdpConfig();
        String providerId = identityProviderConfig.getAlias();
        context.getIdp().preprocessFederatedIdentity(this.session, this.realm, context);
        Set mappers = this.session.identityProviders().getMappersByAliasStream(context.getIdpConfig().getAlias()).collect(Collectors.toSet());
        KeycloakSessionFactory sessionFactory = this.session.getKeycloakSessionFactory();
        for (IdentityProviderMapperModel mapper : mappers) {
            IdentityProviderMapper target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
            target.preprocessFederatedIdentity(this.session, this.realm, mapper, context);
        }
        UserModel user = null;
        if (!context.getIdpConfig().isTransientUsers()) {
            FederatedIdentityModel federatedIdentityModel = new FederatedIdentityModel(providerId, context.getId(), context.getUsername(), context.getToken());
            user = this.session.users().getUserByFederatedIdentity(this.realm, federatedIdentityModel);
        }
        if (user == null || context.getIdpConfig().isTransientUsers()) {
            Object existingUser;
            logger.debugf("Federated user not found for provider '%s' and broker username '%s'.", (Object)providerId, (Object)context.getUsername());
            Object username = context.getModelUsername();
            if (username == null) {
                username = this.realm.isRegistrationEmailAsUsername() && !Validation.isBlank(context.getEmail()) ? context.getEmail() : (context.getUsername() == null ? context.getIdpConfig().getAlias() + "." + context.getId() : context.getUsername());
            }
            username = ((String)username).trim();
            context.setModelUsername((String)username);
            if (context.getEmail() != null && !this.realm.isDuplicateEmailsAllowed() && (existingUser = this.session.users().getUserByEmail(this.realm, context.getEmail())) != null) {
                this.event.error("federated_identity_account_exists");
                throw new CorsErrorResponseException(this.cors, "invalid_token", "User already exists", Response.Status.BAD_REQUEST);
            }
            existingUser = this.session.users().getUserByUsername(this.realm, (String)username);
            if (existingUser != null) {
                this.event.error("federated_identity_account_exists");
                throw new CorsErrorResponseException(this.cors, "invalid_token", "User already exists", Response.Status.BAD_REQUEST);
            }
            if (context.getIdpConfig().isTransientUsers()) {
                String authSessionId = context.getAuthenticationSession() != null && context.getAuthenticationSession().getParentSession() != null ? context.getAuthenticationSession().getParentSession().getId() : null;
                user = new LightweightUserAdapter(this.session, this.realm, authSessionId);
            } else {
                user = this.session.users().addUser(this.realm, (String)username);
            }
            user.setEnabled(true);
            user.setEmail(context.getEmail());
            user.setFirstName(context.getFirstName());
            user.setLastName(context.getLastName());
            if (!context.getIdpConfig().isTransientUsers()) {
                FederatedIdentityModel federatedIdentityModel = new FederatedIdentityModel(context.getIdpConfig().getAlias(), context.getId(), context.getModelUsername(), context.getToken());
                this.session.users().addFederatedIdentity(this.realm, user, federatedIdentityModel);
            }
            context.getIdp().importNewUser(this.session, this.realm, user, context);
            for (IdentityProviderMapperModel mapper : mappers) {
                IdentityProviderMapper target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
                target.importNewUser(this.session, this.realm, user, mapper, context);
            }
            if (context.getIdpConfig().isTrustEmail() && !Validation.isBlank(user.getEmail())) {
                logger.debugf("Email verified automatically after registration of user '%s' through Identity provider '%s' ", (Object)user.getUsername(), (Object)context.getIdpConfig().getAlias());
                user.setEmailVerified(true);
            }
            this.event.clone().event(EventType.REGISTER).user(user.getId()).detail("register_method", "token-exchange").detail("email", user.getEmail()).detail("identity_provider", providerId).success();
        } else {
            if (!user.isEnabled()) {
                this.event.error("user_disabled");
                throw new CorsErrorResponseException(this.cors, "invalid_token", "Invalid Token", Response.Status.BAD_REQUEST);
            }
            String bruteForceError = AuthenticatorUtils.getDisabledByBruteForceEventError((BruteForceProtector)this.session.getProvider(BruteForceProtector.class), this.session, this.realm, user);
            if (bruteForceError != null) {
                this.event.error(bruteForceError);
                throw new CorsErrorResponseException(this.cors, "invalid_token", "Invalid Token", Response.Status.BAD_REQUEST);
            }
            context.getIdp().updateBrokeredUser(this.session, this.realm, user, context);
            for (IdentityProviderMapperModel mapper : mappers) {
                IdentityProviderMapper target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
                IdentityProviderMapperSyncModeDelegate.delegateUpdateBrokeredUser((KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)user, (IdentityProviderMapperModel)mapper, (BrokeredIdentityContext)context, (IdentityProviderMapper)target);
            }
        }
        for (Map.Entry attr : context.getAttributes().entrySet().stream().sorted(Map.Entry.comparingByKey()).toList()) {
            if ("username".equalsIgnoreCase((String)attr.getKey())) continue;
            user.setAttribute((String)attr.getKey(), (List)attr.getValue());
        }
        return user;
    }

    private void updateUserSessionFromClientAuth(UserSessionModel userSession) {
        for (Map.Entry<String, String> attr : this.clientAuthAttributes.entrySet()) {
            userSession.setNote(attr.getKey(), attr.getValue());
        }
    }

    private ExternalExchangeContext locateExchangeExternalTokenByAlias(String alias) {
        try {
            IdentityProvider<?> idp = IdentityBrokerService.getIdentityProvider(this.session, alias);
            if (idp instanceof ExchangeExternalToken) {
                ExchangeExternalToken external = (ExchangeExternalToken)idp;
                IdentityProviderModel model = this.session.identityProviders().getByAlias(alias);
                return new ExternalExchangeContext(external, model);
            }
        }
        catch (IdentityBrokerException identityBrokerException) {
            // empty catch block
        }
        return this.session.identityProviders().getAllStream().map(idpModel -> {
            ExchangeExternalToken external;
            IdentityProvider<?> idp = IdentityBrokerService.getIdentityProvider(this.session, idpModel.getAlias());
            if (idp instanceof ExchangeExternalToken && (external = (ExchangeExternalToken)idp).isIssuer(alias, this.formParams)) {
                return new ExternalExchangeContext(external, (IdentityProviderModel)idpModel);
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    record ExternalExchangeContext(ExchangeExternalToken provider, IdentityProviderModel idpModel) {
    }
}

