/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class SumReturnTypeResolver
implements FunctionReturnTypeResolver {
    private final BasicType<Long> longType;
    private final BasicType<Double> doubleType;
    private final BasicType<BigInteger> bigIntegerType;
    private final BasicType<BigDecimal> bigDecimalType;

    public SumReturnTypeResolver(TypeConfiguration typeConfiguration) {
        BasicType<Long> longType = typeConfiguration.getBasicTypeForJavaType(Long.class);
        BasicType<Double> doubleType = typeConfiguration.getBasicTypeForJavaType(Double.class);
        BasicType<BigInteger> bigIntegerType = typeConfiguration.getBasicTypeForJavaType(BigInteger.class);
        BasicType<BigDecimal> bigDecimalType = typeConfiguration.getBasicTypeForJavaType(BigDecimal.class);
        this.longType = longType;
        this.doubleType = doubleType;
        this.bigIntegerType = bigIntegerType;
        this.bigDecimalType = bigDecimalType;
    }

    @Override
    public ReturnableType<?> resolveFunctionReturnType(ReturnableType<?> impliedType, @Nullable SqmToSqlAstConverter converter, List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
        BasicType basicType;
        if (impliedType != null) {
            return impliedType;
        }
        ReturnableType<?> argType = StandardFunctionReturnTypeResolvers.extractArgumentType(arguments, 1);
        if (argType instanceof BasicType) {
            basicType = (BasicType)argType;
        } else {
            basicType = typeConfiguration.getBasicTypeForJavaType(argType.getJavaType());
            if (basicType == null) {
                return impliedType;
            }
        }
        switch (basicType.getJdbcType().getDefaultSqlTypeCode()) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return this.longType;
            }
            case 6: 
            case 7: 
            case 8: {
                return this.doubleType;
            }
            case 2: 
            case 3: {
                return BigInteger.class.isAssignableFrom(basicType.getJavaType()) ? this.bigIntegerType : this.bigDecimalType;
            }
            case 10000: {
                return basicType;
            }
        }
        return this.bigDecimalType;
    }

    @Override
    public BasicValuedMapping resolveFunctionReturnType(Supplier<BasicValuedMapping> impliedTypeAccess, List<? extends SqlAstNode> arguments) {
        BasicValuedMapping basicValuedMapping;
        if (impliedTypeAccess != null && (basicValuedMapping = impliedTypeAccess.get()) != null) {
            return basicValuedMapping;
        }
        BasicValuedMapping specifiedArgType = StandardFunctionReturnTypeResolvers.extractArgumentValuedMapping(arguments, 1);
        JdbcMapping jdbcMapping = specifiedArgType.getJdbcMapping();
        switch (jdbcMapping.getJdbcType().getDefaultSqlTypeCode()) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return this.longType;
            }
            case 6: 
            case 7: 
            case 8: {
                return this.doubleType;
            }
            case 2: 
            case 3: {
                Class argTypeClass = jdbcMapping.getJavaTypeDescriptor().getJavaTypeClass();
                return BigInteger.class.isAssignableFrom(argTypeClass) ? this.bigIntegerType : this.bigDecimalType;
            }
            case 10000: {
                return (BasicValuedMapping)((Object)jdbcMapping);
            }
        }
        return this.bigDecimalType;
    }
}

