/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

public class ConstructorPropertiesProcessor {
    private static final DotName CONSTRUCTOR_PROPERTIES = DotName.createSimple((String)"java.beans.ConstructorProperties");

    @BuildStep
    void build(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem indexBuildItem) {
        IndexView index = indexBuildItem.getIndex();
        for (AnnotationInstance annotationInstance : index.getAnnotations(CONSTRUCTOR_PROPERTIES)) {
            this.registerInstance(reflectiveClass, annotationInstance);
        }
    }

    private void registerInstance(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, AnnotationInstance instance) {
        AnnotationTarget annotationTarget = instance.target();
        if (annotationTarget instanceof MethodInfo) {
            MethodInfo methodInfo = (MethodInfo)annotationTarget;
            String classname = methodInfo.declaringClass().toString();
            reflectiveClass.produce(this.asReflectiveClassBuildItem(classname));
        }
    }

    private ReflectiveClassBuildItem asReflectiveClassBuildItem(String annotatedClass) {
        return ReflectiveClassBuildItem.builder(annotatedClass).methods().build();
    }
}

