/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.naming;

import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.NamingStrategyHelper;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.StringHelper;

public class ObjectNameNormalizer {
    private final MetadataBuildingContext context;

    public ObjectNameNormalizer(MetadataBuildingContext context) {
        this.context = context;
    }

    public Identifier normalizeIdentifierQuoting(String identifierText) {
        return this.database().toIdentifier(identifierText);
    }

    protected Database database() {
        return this.getBuildingContext().getMetadataCollector().getDatabase();
    }

    public Identifier normalizeIdentifierQuoting(Identifier identifier) {
        return this.database().getJdbcEnvironment().getIdentifierHelper().normalizeQuoting(identifier);
    }

    public String normalizeIdentifierQuotingAsString(String identifierText) {
        Identifier identifier = this.normalizeIdentifierQuoting(identifierText);
        return identifier == null ? null : identifier.render(this.database().getDialect());
    }

    public String toDatabaseIdentifierText(String identifierText) {
        return this.database().getDialect().quote(this.normalizeIdentifierQuotingAsString(identifierText));
    }

    public Identifier determineLogicalName(String explicitName, NamingStrategyHelper namingStrategyHelper) {
        Identifier logicalName = StringHelper.isEmpty(explicitName) ? namingStrategyHelper.determineImplicitName(this.getBuildingContext()) : namingStrategyHelper.handleExplicitName(explicitName, this.getBuildingContext());
        return this.database().getJdbcEnvironment().getIdentifierHelper().normalizeQuoting(logicalName);
    }

    public String applyGlobalQuoting(String text) {
        return this.database().getJdbcEnvironment().getIdentifierHelper().applyGlobalQuoting(text).render(this.database().getDialect());
    }

    protected MetadataBuildingContext getBuildingContext() {
        return this.context;
    }
}

