/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.status;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.infinispan.xsite.status.SiteStatus;

public abstract class AbstractMixedSiteStatus<E>
implements SiteStatus {
    protected final List<E> online;
    protected final List<E> offline;

    protected AbstractMixedSiteStatus(Collection<E> online, Collection<E> offline) {
        this.online = AbstractMixedSiteStatus.toImmutable(online);
        this.offline = AbstractMixedSiteStatus.toImmutable(offline);
    }

    protected static <E> List<E> toImmutable(Collection<E> collection) {
        return Collections.unmodifiableList(new ArrayList<E>(collection));
    }

    @Override
    public final boolean isOnline() {
        return false;
    }

    @Override
    public final boolean isOffline() {
        return false;
    }

    public List<E> getOnline() {
        return this.online;
    }

    public List<E> getOffline() {
        return this.offline;
    }
}

