/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.CheckedIntConsumer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.util.FixedBitSet;

final class DISIDocIdStream
extends DocIdStream {
    private final DocIdSetIterator iterator;
    private final int max;
    private final FixedBitSet spare;

    DISIDocIdStream(DocIdSetIterator iterator, int max, FixedBitSet spare) {
        if (max - iterator.docID() > spare.length()) {
            throw new IllegalArgumentException("Bit set is too small to hold all potential matches");
        }
        this.iterator = iterator;
        this.max = max;
        this.spare = spare;
    }

    @Override
    public boolean mayHaveRemaining() {
        return this.iterator.docID() < this.max;
    }

    @Override
    public void forEach(int upTo, CheckedIntConsumer<IOException> consumer) throws IOException {
        upTo = Math.min(upTo, this.max);
        int doc = this.iterator.docID();
        while (doc < upTo) {
            consumer.accept(doc);
            doc = this.iterator.nextDoc();
        }
    }

    @Override
    public int count(int upTo) throws IOException {
        if (this.iterator.docID() >= upTo) {
            return 0;
        }
        assert (this.spare.scanIsEmpty());
        upTo = Math.min(upTo, this.max);
        int offset = this.iterator.docID();
        this.iterator.intoBitSet(upTo, this.spare, offset);
        int count = this.spare.cardinality(0, upTo - offset);
        this.spare.clear(0, upTo - offset);
        assert (this.spare.scanIsEmpty());
        return count;
    }
}

