/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import mediathek.config.MVConfig;
import mediathek.tool.ApplicationConfiguration;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.configuration2.Configuration;

public class PanelDownload
extends JPanel {
    private JCheckBox cbkDownloadError;
    private JCheckBox jCheckBoxBeep;
    private JButton jButtonBeep;
    private JCheckBox cbFetchMissingFileSize;
    private JSpinner spDefaultDownloadContinuation;

    public PanelDownload() {
        this.initComponents();
        this.cbkDownloadError.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_DOWNLOAD_ERRORMSG)));
        this.cbkDownloadError.addActionListener(e -> MVConfig.add(MVConfig.Configs.SYSTEM_DOWNLOAD_ERRORMSG, Boolean.toString(this.cbkDownloadError.isSelected())));
        Configuration config = ApplicationConfiguration.getConfiguration();
        this.jCheckBoxBeep.setSelected(config.getBoolean("download.sound.beep", false));
        this.jCheckBoxBeep.addActionListener(l -> config.setProperty("download.sound.beep", (Object)this.jCheckBoxBeep.isSelected()));
        this.cbFetchMissingFileSize.setSelected(config.getBoolean("download.fetch_file_size", true));
        this.cbFetchMissingFileSize.addActionListener(l -> config.setProperty("download.fetch_file_size", (Object)this.cbFetchMissingFileSize.isSelected()));
        this.jButtonBeep.addActionListener(ae -> Toolkit.getDefaultToolkit().beep());
        int countdown = ApplicationConfiguration.getConfiguration().getInt("download.continuation.time", 60);
        if (countdown < 1 || countdown > 60) {
            countdown = 60;
        }
        this.spDefaultDownloadContinuation.setValue(countdown);
        this.spDefaultDownloadContinuation.addChangeListener(e -> {
            int val = (Integer)this.spDefaultDownloadContinuation.getValue();
            config.setProperty("download.continuation.time", (Object)val);
        });
    }

    private void initComponents() {
        JPanel jPanel2 = new JPanel();
        this.cbkDownloadError = new JCheckBox();
        this.jCheckBoxBeep = new JCheckBox();
        this.jButtonBeep = new JButton();
        this.cbFetchMissingFileSize = new JCheckBox();
        JPanel panel1 = new JPanel();
        JLabel label1 = new JLabel();
        this.spDefaultDownloadContinuation = new JSpinner();
        this.setLayout(new BorderLayout());
        jPanel2.setLayout((LayoutManager)new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().align("left").gap().fill(), new AC().fill().gap().fill().gap().gap()));
        this.cbkDownloadError.setText("Bei Downloadfehler eine Fehlermeldung anzeigen");
        jPanel2.add((Component)this.cbkDownloadError, new CC().cell(new int[]{0, 0}));
        this.jCheckBoxBeep.setText("Nach jedem Download einen \"Beep\" ausgeben");
        jPanel2.add((Component)this.jCheckBoxBeep, new CC().cell(new int[]{0, 1}));
        this.jButtonBeep.setText("Test");
        jPanel2.add((Component)this.jButtonBeep, new CC().cell(new int[]{1, 1}));
        this.cbFetchMissingFileSize.setText("Fehlende Filmgr\u00f6\u00dfe nachladen");
        jPanel2.add((Component)this.cbFetchMissingFileSize, new CC().cell(new int[]{0, 2}));
        panel1.setLayout(new FlowLayout(0));
        label1.setText("Standard-Wert f\u00fcr automatische Weiterf\u00fchrung:");
        panel1.add(label1);
        this.spDefaultDownloadContinuation.setModel(new SpinnerNumberModel(1, 1, 60, 1));
        panel1.add(this.spDefaultDownloadContinuation);
        jPanel2.add((Component)panel1, new CC().cell(new int[]{0, 3, 2, 1}));
        this.add((Component)jPanel2, "Center");
    }
}

