/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import com.ibm.icu.text.Transliterator;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import mediathek.tool.ReplaceList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilenameUtils {
    public static final String REGEXP_ILLEGAL_CHARACTERS_WINDOWS = "[:\\\\/*?|<>\"]";
    public static final String REGEXP_ILLEGAL_CHARACTERS_WINDOWS_PATH = "[:/*?|<>\"]";
    public static final String REGEXP_ILLEGAL_CHARACTERS_OTHERS = "[:\\\\/*|<>]";
    public static final String REGEXP_ILLEGAL_CHARACTERS_OTHERS_PATH = "[:\\\\*|<>]";
    private static final Logger logger = LogManager.getLogger();

    public static String checkDateiname(String name, boolean isPath) {
        Object ret = name;
        boolean isWindowsPath = false;
        String splitChar = SystemUtils.IS_OS_WINDOWS ? "\\\\" : "/";
        if (SystemUtils.IS_OS_WINDOWS) {
            ret = FilenameUtils.removeWindowsTrailingDots((String)ret);
            if (isPath && ((String)ret).length() > 1 && ((String)ret).charAt(1) == ':') {
                isWindowsPath = true;
                ret = ((String)ret).replaceFirst(":", "");
            }
        } else {
            ret = StringUtils.stripStart((String)ret, (String)".");
        }
        if (isPath && ((String)ret).contains(File.separator)) {
            String[] sa;
            Object str = "";
            for (String s : sa = ((String)ret).split(splitChar)) {
                if (s.isEmpty()) continue;
                str = (String)str + File.separator + FilenameUtils.convertToNativeEncoding(s, false);
            }
            if (!((String)ret).startsWith(File.separator)) {
                str = ((String)str).replaceFirst(splitChar, "");
            }
            if (((String)ret).endsWith(File.separator)) {
                str = (String)str + File.separator;
            }
            ret = str;
        } else {
            ret = FilenameUtils.convertToNativeEncoding((String)ret, false);
        }
        if (isWindowsPath) {
            if (((String)ret).length() == 1) {
                ret = (String)ret + ":";
            } else if (((String)ret).length() > 1) {
                ret = ((String)ret).charAt(0) + ":" + ((String)ret).substring(1);
            }
        }
        return ret;
    }

    protected static String removeWindowsTrailingDots(String fileName) {
        while (!fileName.isEmpty() && (fileName.endsWith(".") || fileName.endsWith(" "))) {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        return fileName;
    }

    private static String convertToNativeEncoding(String fileName, boolean isPath) {
        String ret = fileName;
        ret = FilenameUtils.removeIllegalCharacters(ret, isPath);
        try {
            CharsetEncoder charsetEncoder = Charset.defaultCharset().newEncoder();
            charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE);
            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            charsetEncoder.replaceWith(new byte[]{95});
            ByteBuffer buf = charsetEncoder.encode(CharBuffer.wrap(ret));
            if (buf.hasArray()) {
                ret = new String(buf.array());
            }
            ret = ret.replaceAll("\\u0000", "");
        }
        catch (CharacterCodingException e) {
            logger.error("convertToNativeEncoding", (Throwable)e);
        }
        return ret;
    }

    protected static String convertToASCIIEncoding(String fileName, boolean isPath) {
        String ret = fileName;
        ret = ret.replaceAll("\\u0000", "");
        Transliterator transliterator = Transliterator.getInstance("de-ASCII");
        ret = transliterator.transliterate(ret);
        ret = FilenameUtils.removeIllegalCharacters(ret, isPath);
        try {
            CharsetEncoder charsetEncoder = StandardCharsets.US_ASCII.newEncoder();
            charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE);
            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            charsetEncoder.replaceWith(new byte[]{95});
            ByteBuffer buf = charsetEncoder.encode(CharBuffer.wrap(ret));
            if (buf.hasArray()) {
                ret = new String(buf.array());
            }
        }
        catch (CharacterCodingException e) {
            logger.error("convertToASCIIEncoding", (Throwable)e);
        }
        return ret;
    }

    public static String removeIllegalCharacters(String input, boolean isPath) {
        String ret = input;
        if (SystemUtils.IS_OS_WINDOWS) {
            ret = FilenameUtils.removeWindowsTrailingDots(ret);
            ret = ret.replaceAll(isPath ? REGEXP_ILLEGAL_CHARACTERS_WINDOWS_PATH : REGEXP_ILLEGAL_CHARACTERS_WINDOWS, "_");
        } else if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC_OSX) {
            ret = StringUtils.stripStart((String)ret, (String)".");
            ret = ret.replaceAll(isPath ? REGEXP_ILLEGAL_CHARACTERS_OTHERS_PATH : REGEXP_ILLEGAL_CHARACTERS_OTHERS, "_");
        } else {
            throw new IllegalStateException("Unsupported OS: " + SystemUtils.OS_NAME);
        }
        return ret;
    }

    public static String replaceLeerDateiname(String name, boolean isPath, boolean userReplace, boolean onlyAscii) {
        Object ret = name;
        boolean isWindowsPath = false;
        if (SystemUtils.IS_OS_WINDOWS && isPath && ((String)ret).length() > 1 && ((String)ret).charAt(1) == ':') {
            isWindowsPath = true;
            ret = ((String)ret).replaceFirst(":", "");
        }
        if (userReplace) {
            ret = ReplaceList.replace((String)ret, isPath);
        }
        ret = onlyAscii ? FilenameUtils.convertToASCIIEncoding((String)ret, isPath) : FilenameUtils.convertToNativeEncoding((String)ret, isPath);
        if (isWindowsPath) {
            if (((String)ret).length() == 1) {
                ret = (String)ret + ":";
            } else if (((String)ret).length() > 1) {
                ret = ((String)ret).charAt(0) + ":" + ((String)ret).substring(1);
            }
        }
        return ret;
    }
}

