/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandSkinParamMultilines;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexRepeatedOneOrMore;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandSkinParamJaws
extends SingleLineCommand2<TitledDiagram> {
    public static final CommandSkinParamJaws ME = new CommandSkinParamJaws();
    private final CommandSkinParamMultilines delegate = CommandSkinParamMultilines.ME;

    private CommandSkinParamJaws() {
        super(CommandSkinParamJaws.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandSkinParamJaws.class.getName(), RegexLeaf.start(), new RegexRepeatedOneOrMore("FULL", (IRegex)new RegexConcat(new RegexLeaf(1, "TYPE", "(skinparam|skinparamlocked)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(".*\ue100.*"))), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(TitledDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        String full = arg.get("FULL", 0);
        BlocLines lines = BlocLines.create();
        for (String line : full.split("\ue100")) {
            lines = lines.addString(line);
            if (!line.trim().equals("}")) continue;
            CommandExecutionResult res = this.delegate.execute(diagram, lines, currentPass);
            if (!res.isOk()) {
                return res;
            }
            lines = BlocLines.create();
        }
        diagram.setSkinParamUsed(true);
        return CommandExecutionResult.ok();
    }
}

