/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.nodespacing.internal.algorithm;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.elk.alg.common.nodespacing.cellsystem.AtomicCell;
import org.eclipse.elk.alg.common.nodespacing.internal.NodeContext;
import org.eclipse.elk.alg.common.nodespacing.internal.PortContext;
import org.eclipse.elk.alg.common.nodespacing.internal.algorithm.HorizontalPortPlacementSizeCalculator;
import org.eclipse.elk.alg.common.nodespacing.internal.algorithm.PortPlacementCalculator;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.options.PortAlignment;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.ElkUtil;

public final class VerticalPortPlacementSizeCalculator {
    private VerticalPortPlacementSizeCalculator() {
    }

    public static void calculateVerticalPortPlacementSize(NodeContext nodeContext) {
        switch (nodeContext.portConstraints) {
            case FIXED_POS: {
                VerticalPortPlacementSizeCalculator.calculateVerticalNodeSizeRequiredByFixedPosPorts(nodeContext, PortSide.EAST);
                VerticalPortPlacementSizeCalculator.calculateVerticalNodeSizeRequiredByFixedPosPorts(nodeContext, PortSide.WEST);
                break;
            }
            case FIXED_RATIO: {
                VerticalPortPlacementSizeCalculator.calculateVerticalNodeSizeRequiredByFixedRatioPorts(nodeContext, PortSide.EAST);
                VerticalPortPlacementSizeCalculator.calculateVerticalNodeSizeRequiredByFixedRatioPorts(nodeContext, PortSide.WEST);
                break;
            }
            default: {
                VerticalPortPlacementSizeCalculator.calculateVerticalNodeSizeRequiredByFreePorts(nodeContext, PortSide.EAST);
                VerticalPortPlacementSizeCalculator.calculateVerticalNodeSizeRequiredByFreePorts(nodeContext, PortSide.WEST);
            }
        }
    }

    private static void calculateVerticalNodeSizeRequiredByFixedPosPorts(NodeContext nodeContext, PortSide portSide) {
        double bottommostPortBorder = 0.0;
        for (PortContext portContext : nodeContext.portContexts.get(portSide)) {
            bottommostPortBorder = Math.max(bottommostPortBorder, portContext.portPosition.y + portContext.port.getSize().y);
        }
        AtomicCell cell = nodeContext.insidePortLabelCells.get((Object)portSide);
        cell.getPadding().top = 0.0;
        cell.getMinimumContentAreaSize().y = bottommostPortBorder;
    }

    private static void calculateVerticalNodeSizeRequiredByFixedRatioPorts(NodeContext nodeContext, PortSide portSide) {
        AtomicCell cell = nodeContext.insidePortLabelCells.get((Object)portSide);
        Collection<PortContext> portContexts = nodeContext.portContexts.get(portSide);
        if (portContexts.isEmpty()) {
            cell.getPadding().top = 0.0;
            cell.getPadding().bottom = 0.0;
            return;
        }
        boolean portLabelsInside = nodeContext.portLabelsPlacement.contains((Object)PortLabelPlacement.INSIDE);
        double minHeight = 0.0;
        if (nodeContext.sizeConstraints.contains((Object)SizeConstraint.PORT_LABELS)) {
            VerticalPortPlacementSizeCalculator.setupPortMargins(nodeContext, portSide);
        }
        Iterator<PortContext> portContextIterator = portContexts.iterator();
        PortContext previousPortContext = null;
        double previousPortRatio = 0.0;
        double previousPortHeight = 0.0;
        while (portContextIterator.hasNext()) {
            PortContext currentPortContext = portContextIterator.next();
            double currentPortRatio = currentPortContext.port.getProperty(PortPlacementCalculator.PORT_RATIO_OR_POSITION);
            double currentPortHeight = currentPortContext.port.getSize().y;
            if (previousPortContext == null) {
                if (nodeContext.surroundingPortMargins != null && nodeContext.surroundingPortMargins.top > 0.0) {
                    minHeight = Math.max(minHeight, HorizontalPortPlacementSizeCalculator.minSizeRequiredToRespectSpacing(nodeContext.surroundingPortMargins.top + currentPortContext.portMargin.top, 0.0, currentPortRatio));
                }
            } else {
                double requiredSpace = previousPortHeight + previousPortContext.portMargin.bottom + nodeContext.portPortSpacing + currentPortContext.portMargin.top;
                minHeight = Math.max(minHeight, HorizontalPortPlacementSizeCalculator.minSizeRequiredToRespectSpacing(requiredSpace, previousPortRatio, currentPortRatio));
            }
            previousPortContext = currentPortContext;
            previousPortRatio = currentPortRatio;
            previousPortHeight = currentPortHeight;
        }
        if (nodeContext.surroundingPortMargins != null && nodeContext.surroundingPortMargins.bottom > 0.0) {
            double requiredSpace = previousPortHeight + nodeContext.surroundingPortMargins.bottom;
            if (portLabelsInside) {
                requiredSpace += previousPortContext.portMargin.bottom;
            }
            minHeight = Math.max(minHeight, HorizontalPortPlacementSizeCalculator.minSizeRequiredToRespectSpacing(requiredSpace, previousPortRatio, 1.0));
        }
        cell.getPadding().top = 0.0;
        cell.getMinimumContentAreaSize().y = minHeight;
    }

    private static void calculateVerticalNodeSizeRequiredByFreePorts(NodeContext nodeContext, PortSide portSide) {
        AtomicCell cell = nodeContext.insidePortLabelCells.get((Object)portSide);
        if (nodeContext.portContexts.get(portSide).isEmpty()) {
            cell.getPadding().top = 0.0;
            cell.getPadding().bottom = 0.0;
            return;
        }
        cell.getPadding().top = nodeContext.surroundingPortMargins.top;
        cell.getPadding().bottom = nodeContext.surroundingPortMargins.bottom;
        if (nodeContext.sizeConstraints.contains((Object)SizeConstraint.PORT_LABELS)) {
            VerticalPortPlacementSizeCalculator.setupPortMargins(nodeContext, portSide);
        }
        double height = VerticalPortPlacementSizeCalculator.portHeightPlusPortPortSpacing(nodeContext, portSide);
        if (nodeContext.getPortAlignment(portSide) == PortAlignment.DISTRIBUTED) {
            height += 2.0 * nodeContext.portPortSpacing;
        }
        cell.getMinimumContentAreaSize().y = height;
    }

    private static void setupPortMargins(NodeContext nodeContext, PortSide portSide) {
        Collection<PortContext> portContexts = nodeContext.portContexts.get(portSide);
        boolean portLabelsOutside = nodeContext.portLabelsPlacement.contains((Object)PortLabelPlacement.OUTSIDE);
        boolean alwaysSameSide = nodeContext.portLabelsPlacement.contains((Object)PortLabelPlacement.ALWAYS_SAME_SIDE);
        boolean alwaysSameSideAbove = nodeContext.portLabelsPlacement.contains((Object)PortLabelPlacement.ALWAYS_OTHER_SAME_SIDE);
        boolean spaceEfficient = nodeContext.portLabelsPlacement.contains((Object)PortLabelPlacement.SPACE_EFFICIENT);
        boolean uniformPortSpacing = nodeContext.sizeOptions.contains((Object)SizeOptions.UNIFORM_PORT_SPACING);
        boolean spaceEfficientPortLabels = !alwaysSameSide && !alwaysSameSideAbove && (spaceEfficient || portContexts.size() == 2);
        VerticalPortPlacementSizeCalculator.computeVerticalPortMargins(nodeContext, portSide, portLabelsOutside);
        PortContext topmostPortContext = null;
        PortContext bottommostPortContext = null;
        if (portLabelsOutside) {
            Iterator<PortContext> portContextIterator = portContexts.iterator();
            bottommostPortContext = topmostPortContext = portContextIterator.next();
            while (portContextIterator.hasNext()) {
                bottommostPortContext = portContextIterator.next();
            }
            topmostPortContext.portMargin.top = 0.0;
            bottommostPortContext.portMargin.bottom = 0.0;
            if (spaceEfficientPortLabels && !topmostPortContext.labelsNextToPort) {
                topmostPortContext.portMargin.bottom = 0.0;
            }
        }
        if (uniformPortSpacing) {
            VerticalPortPlacementSizeCalculator.unifyPortMargins(portContexts);
            if (portLabelsOutside) {
                topmostPortContext.portMargin.top = 0.0;
                bottommostPortContext.portMargin.bottom = 0.0;
            }
        }
    }

    private static void computeVerticalPortMargins(NodeContext nodeContext, PortSide portSide, boolean portLabelsOutside) {
        for (PortContext portContext : nodeContext.portContexts.get(portSide)) {
            double labelHeight;
            double d = labelHeight = portContext.portLabelCell != null ? portContext.portLabelCell.getMinimumHeight() : 0.0;
            if (labelHeight > 0.0) {
                if (portContext.labelsNextToPort) {
                    double portHeight = portContext.port.getSize().y;
                    if (!(labelHeight > portHeight)) continue;
                    if (nodeContext.portLabelsTreatAsGroup || portContext.portLabelCell.getLabels().size() == 1) {
                        double overhang;
                        portContext.portMargin.top = overhang = (labelHeight - portHeight) / 2.0;
                        portContext.portMargin.bottom = overhang;
                        continue;
                    }
                    double firstLabelHeight = portContext.portLabelCell.getLabels().get((int)0).getSize().y;
                    double firstLabelOverhang = (firstLabelHeight - portHeight) / 2.0;
                    portContext.portMargin.top = Math.max(0.0, firstLabelOverhang);
                    portContext.portMargin.bottom = labelHeight - firstLabelOverhang - portHeight;
                    continue;
                }
                portContext.portMargin.bottom = nodeContext.portLabelSpacingVertical + labelHeight;
                continue;
            }
            if (!PortLabelPlacement.isFixed(nodeContext.portLabelsPlacement)) continue;
            ElkRectangle labelsBounds = ElkUtil.getLabelsBounds(portContext.port);
            if (labelsBounds.y < 0.0) {
                portContext.portMargin.top = -labelsBounds.y;
            }
            if (!(labelsBounds.y + labelsBounds.height > portContext.port.getSize().y)) continue;
            portContext.portMargin.bottom = labelsBounds.y + labelsBounds.height - portContext.port.getSize().y;
        }
    }

    private static void unifyPortMargins(Collection<PortContext> portContexts) {
        double maxTop = 0.0;
        double maxBottom = 0.0;
        for (PortContext portContext : portContexts) {
            maxTop = Math.max(maxTop, portContext.portMargin.top);
            maxBottom = Math.max(maxBottom, portContext.portMargin.bottom);
        }
        for (PortContext portContext : portContexts) {
            portContext.portMargin.top = maxTop;
            portContext.portMargin.bottom = maxBottom;
        }
    }

    private static double portHeightPlusPortPortSpacing(NodeContext nodeContext, PortSide portSide) {
        double result = 0.0;
        Iterator<PortContext> portContextIterator = nodeContext.portContexts.get(portSide).iterator();
        while (portContextIterator.hasNext()) {
            PortContext portContext = portContextIterator.next();
            result += portContext.portMargin.top + portContext.port.getSize().y + portContext.portMargin.bottom;
            if (!portContextIterator.hasNext()) continue;
            result += nodeContext.portPortSpacing;
        }
        return result;
    }
}

