/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.tuple;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsule;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.tuple.CapsuleBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Collections;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.Capsule})
public class CapsuleBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = CapsuleBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return Collections.emptyList();
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object repr(PyCapsule self) {
            String name;
            if (self.getNamePtr() == null || InteropLibrary.getUncached().isNull(self.getNamePtr())) {
                name = "NULL";
            } else {
                byte b;
                StringBuilder builder = new StringBuilder("\"");
                int i = 0;
                while ((b = CStructAccess.ReadByteNode.getUncached().readArrayElement(self.getNamePtr(), i++)) != 0) {
                    builder.append((char)b);
                }
                builder.append('\"');
                name = builder.toString();
            }
            return TruffleString.fromJavaStringUncached((String)String.format("<capsule object %s at 0x%s>", name, PythonAbstractNativeObject.systemHashCodeAsHexString(self)), (TruffleString.Encoding)PythonUtils.TS_ENCODING);
        }
    }
}

