/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotUnaryFunc;
import com.oracle.graal.python.lib.PyNumberNegativeNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.expression.UnaryOpNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.bytecode.OperationProxy;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline(value=false)
@OperationProxy.Proxyable
public abstract class PyNumberNegativeNode
extends UnaryOpNode {
    public static final int INT_MIN_VALUE = Integer.MIN_VALUE;
    public static final long LONG_MIN_VALUE = Long.MIN_VALUE;

    @Specialization(guards={"object != INT_MIN_VALUE"})
    public static int doInt(int object) {
        return -object;
    }

    @Specialization(guards={"object == INT_MIN_VALUE"})
    public static long doIntMin(int object) {
        return 0x80000000L;
    }

    @Specialization(guards={"object != LONG_MIN_VALUE"})
    public static long doLong(long object) {
        return -object;
    }

    @Specialization
    public static double doDouble(double object) {
        return -object;
    }

    @HostCompilerDirectives.InliningCutoff
    @Fallback
    public static Object doObject(VirtualFrame frame, Object object, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Cached TpSlots.GetCachedTpSlotsNode getSlots, @Cached TpSlotUnaryFunc.CallSlotUnaryNode callSlot, @Cached PRaiseNode raiseNode) {
        Object type = getClassNode.execute(inliningTarget, object);
        TpSlots slots = getSlots.execute(inliningTarget, type);
        if (slots.nb_negative() != null) {
            return callSlot.execute(frame, inliningTarget, slots.nb_negative(), object);
        }
        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.BAD_OPERAND_FOR, "unary", "-", object);
    }

    @NeverDefault
    public static PyNumberNegativeNode create() {
        return PyNumberNegativeNodeGen.create();
    }

    public static PyNumberNegativeNode getUncached() {
        return PyNumberNegativeNodeGen.getUncached();
    }
}

