/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence;

import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;

@ExportLibrary(value=InteropLibrary.class)
public abstract class PSequence
extends PythonBuiltinObject {
    public PSequence(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
    }

    public abstract SequenceStorage getSequenceStorage();

    public abstract void setSequenceStorage(SequenceStorage var1);

    @ExportMessage
    public final boolean isNumber() {
        return false;
    }

    @ExportMessage
    public final byte asByte() throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public final boolean fitsInByte() {
        return false;
    }

    @ExportMessage
    public final short asShort() throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public final boolean fitsInShort() {
        return false;
    }

    @ExportMessage
    public final int asInt() throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public final boolean fitsInInt() {
        return false;
    }

    @ExportMessage
    public final long asLong() throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public final boolean fitsInLong() {
        return false;
    }

    @ExportMessage
    public final float asFloat() throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public final boolean fitsInFloat() {
        return false;
    }

    @ExportMessage
    public final double asDouble() throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public final boolean fitsInDouble() {
        return false;
    }

    @ExportMessage
    public boolean isString() {
        return false;
    }

    @ExportMessage
    public final String asString() throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public final boolean hasArrayElements() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public final long getArraySize(@Bind Node inliningTarget, @Cached.Exclusive @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            long l = getSequenceStorageNode.execute(inliningTarget, this).length();
            return l;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public final Object readArrayElement(long index, @Bind Node inliningTarget, @Cached.Exclusive @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached.Exclusive @Cached SequenceStorageNodes.GetItemScalarNode getItem, @Cached.Exclusive @Cached GilNode gil) throws InvalidArrayIndexException {
        boolean mustRelease = gil.acquire();
        try {
            Object object = getItem.execute(inliningTarget, getSequenceStorageNode.execute(inliningTarget, this), PInt.intValueExact(index));
            return object;
        }
        catch (OverflowException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw InvalidArrayIndexException.create((long)index);
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public final void writeArrayElement(long index, Object value, @Bind Node inliningTarget, @Cached.Exclusive @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached.Exclusive @Cached PForeignToPTypeNode convert, @Cached.Exclusive @Cached SequenceStorageNodes.SetItemScalarNode setItem, @Cached.Exclusive @Cached GilNode gil) throws InvalidArrayIndexException {
        boolean mustRelease = gil.acquire();
        try {
            try {
                setItem.execute(inliningTarget, getSequenceStorageNode.execute(inliningTarget, this), PInt.intValueExact(index), convert.executeConvert(value));
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw InvalidArrayIndexException.create((long)index);
            }
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public final void removeArrayElement(long index, @Bind Node inliningTarget, @Cached.Exclusive @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached.Exclusive @Cached SequenceStorageNodes.DeleteItemNode delItem, @Cached.Exclusive @Cached GilNode gil) throws InvalidArrayIndexException {
        boolean mustRelease = gil.acquire();
        try {
            try {
                delItem.execute(inliningTarget, getSequenceStorageNode.execute(inliningTarget, this), PInt.intValueExact(index));
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw InvalidArrayIndexException.create((long)index);
            }
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public final boolean isArrayElementReadable(long idx, @Bind Node inliningTarget, @Cached.Exclusive @Cached SequenceNodes.IsInBoundsNode isInBoundsNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            boolean bl = isInBoundsNode.execute(inliningTarget, this, idx);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public final boolean isArrayElementModifiable(long idx, @Bind Node inliningTarget, @Cached.Exclusive @Cached SequenceNodes.IsInBoundsNode isInBoundsNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            boolean bl = isInBoundsNode.execute(inliningTarget, this, idx);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public final boolean isArrayElementInsertable(long idx, @Bind Node inliningTarget, @Cached.Exclusive @Cached SequenceNodes.IsInBoundsNode isInBoundsNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            boolean bl = !isInBoundsNode.execute(inliningTarget, this, idx);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public final boolean isArrayElementRemovable(long idx, @Bind Node inliningTarget, @Cached.Exclusive @Cached SequenceNodes.IsInBoundsNode isInBoundsNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            boolean bl = isInBoundsNode.execute(inliningTarget, this, idx);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }
}

