/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser.text;

import org.thymeleaf.templateparser.text.ITextHandler;
import org.thymeleaf.templateparser.text.TextParseException;
import org.thymeleaf.templateparser.text.TextParsingUtil;

final class TextParsingAttributeSequenceUtil {
    private TextParsingAttributeSequenceUtil() {
    }

    public static void parseAttributeSequence(char[] buffer, int offset, int len, int line, int col, ITextHandler handler) throws TextParseException {
        int i;
        int maxi = offset + len;
        int[] locator = new int[]{line, col};
        int current = i = offset;
        while (i < maxi) {
            int valueEnd;
            int j;
            boolean equalsPresent;
            int wsEnd = TextParsingUtil.findNextNonWhitespaceCharWildcard(buffer, i, maxi, locator);
            if (wsEnd == -1) {
                i = maxi;
                continue;
            }
            if (wsEnd > current) {
                current = i = wsEnd;
            }
            int currentArtifactLine = locator[0];
            int currentArtifactCol = locator[1];
            int attributeNameEnd = TextParsingUtil.findNextOperatorCharWildcard(buffer, i, maxi, locator);
            if (attributeNameEnd == -1) {
                handler.handleAttribute(buffer, current, maxi - current, currentArtifactLine, currentArtifactCol, 0, 0, locator[0], locator[1], 0, 0, 0, 0, locator[0], locator[1]);
                i = maxi;
                continue;
            }
            if (attributeNameEnd <= current) {
                throw new TextParseException("Bad attribute name in sequence \"" + new String(buffer, offset, len) + "\": attribute names cannot start with an equals sign", currentArtifactLine, currentArtifactCol);
            }
            int attributeNameOffset = current;
            int attributeNameLen = attributeNameEnd - current;
            int attributeNameLine = currentArtifactLine;
            int attributeNameCol = currentArtifactCol;
            current = i = attributeNameEnd;
            currentArtifactLine = locator[0];
            currentArtifactCol = locator[1];
            int operatorEnd = TextParsingUtil.findNextNonOperatorCharWildcard(buffer, i, maxi, locator);
            if (operatorEnd == -1) {
                equalsPresent = false;
                for (j = i; j < maxi; ++j) {
                    if (buffer[j] != '=') continue;
                    equalsPresent = true;
                    break;
                }
                if (equalsPresent) {
                    handler.handleAttribute(buffer, attributeNameOffset, attributeNameLen, attributeNameLine, attributeNameCol, current, maxi - current, currentArtifactLine, currentArtifactCol, 0, 0, 0, 0, locator[0], locator[1]);
                } else {
                    handler.handleAttribute(buffer, attributeNameOffset, attributeNameLen, attributeNameLine, attributeNameCol, 0, 0, currentArtifactLine, currentArtifactCol, 0, 0, 0, 0, currentArtifactLine, currentArtifactCol);
                }
                i = maxi;
                continue;
            }
            equalsPresent = false;
            for (j = current; j < operatorEnd; ++j) {
                if (buffer[j] != '=') continue;
                equalsPresent = true;
                break;
            }
            if (!equalsPresent) {
                handler.handleAttribute(buffer, attributeNameOffset, attributeNameLen, attributeNameLine, attributeNameCol, 0, 0, currentArtifactLine, currentArtifactCol, 0, 0, 0, 0, currentArtifactLine, currentArtifactCol);
                current = i = operatorEnd;
                continue;
            }
            int operatorOffset = current;
            int operatorLen = operatorEnd - current;
            int operatorLine = currentArtifactLine;
            int operatorCol = currentArtifactCol;
            current = i = operatorEnd;
            currentArtifactLine = locator[0];
            currentArtifactCol = locator[1];
            boolean attributeEndsWithQuotes = i < maxi && (buffer[current] == '\"' || buffer[current] == '\'');
            int n = valueEnd = attributeEndsWithQuotes ? TextParsingUtil.findNextAnyCharAvoidQuotesWildcard(buffer, i, maxi, locator) : TextParsingUtil.findNextWhitespaceCharWildcard(buffer, i, maxi, false, locator);
            if (valueEnd == -1) {
                int valueContentOffset = current;
                int valueContentLen = maxi - current;
                if (TextParsingAttributeSequenceUtil.isValueSurroundedByCommas(buffer, current, maxi - current)) {
                    ++valueContentOffset;
                    valueContentLen -= 2;
                }
                handler.handleAttribute(buffer, attributeNameOffset, attributeNameLen, attributeNameLine, attributeNameCol, operatorOffset, operatorLen, operatorLine, operatorCol, valueContentOffset, valueContentLen, current, maxi - current, currentArtifactLine, currentArtifactCol);
                i = maxi;
                continue;
            }
            int valueOuterOffset = current;
            int valueOuterLen = valueEnd - current;
            int valueContentOffset = valueOuterOffset;
            int valueContentLen = valueOuterLen;
            if (TextParsingAttributeSequenceUtil.isValueSurroundedByCommas(buffer, valueOuterOffset, valueOuterLen)) {
                valueContentOffset = valueOuterOffset + 1;
                valueContentLen = valueOuterLen - 2;
            }
            handler.handleAttribute(buffer, attributeNameOffset, attributeNameLen, attributeNameLine, attributeNameCol, operatorOffset, operatorLen, operatorLine, operatorCol, valueContentOffset, valueContentLen, valueOuterOffset, valueOuterLen, currentArtifactLine, currentArtifactCol);
            current = i = valueEnd;
        }
    }

    private static boolean isValueSurroundedByCommas(char[] buffer, int offset, int len) {
        return len >= 2 && (buffer[offset] == '\"' && buffer[offset + len - 1] == '\"' || buffer[offset] == '\'' && buffer[offset + len - 1] == '\'');
    }
}

