#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 idris
version:              1.3.3
visibility:           public
id:                   idris-1.3.3-72p9B9doRGfCFjoKtIRiXd
key:                  idris-1.3.3-72p9B9doRGfCFjoKtIRiXd
license:              BSD-3-Clause
maintainer:           Niklas Larsson <niklas@mm.st>
author:               Edwin Brady
stability:            Beta
homepage:             https://www.idris-lang.org/
synopsis:             Functional Programming Language with Dependent Types
description:
    Idris is a general purpose language with full dependent types.
    It is compiled, with eager evaluation.
    Dependent types allow types to be predicated on values,
    meaning that some aspects of a program'\''s behaviour can be
    specified precisely in the type. The language is closely
    related to Epigram and Agda. There is a tutorial at
    <https://www.idris-lang.org/documentation>.
    Features include:

    * Full, first class, dependent types with dependent pattern matching

    * where clauses, with rule, case expressions,
    pattern matching let and lambda bindings

    * Interfaces (similar to type classes), monad comprehensions

    * do notation, idiom brackets, syntactic conveniences for lists,
    tuples, dependent pairs

    * Totality checking

    * Coinductive types

    * Indentation significant syntax, extensible syntax

    * Cumulative universes

    * Simple foreign function interface (to C)

    * Hugs style interactive environment

category:             Compilers/Interpreters, Dependent Types
abi:                  ff987ed5391843dbefc054e4c2f34e37
exposed:              True
exposed-modules:
    IRTS.Bytecode IRTS.CodegenC IRTS.CodegenCommon
    IRTS.CodegenJavaScript IRTS.Compiler IRTS.Defunctionalise
    IRTS.DumpBC IRTS.Exports IRTS.Inliner IRTS.JavaScript.AST
    IRTS.JavaScript.Codegen IRTS.JavaScript.LangTransforms
    IRTS.JavaScript.Name IRTS.JavaScript.PrimOp
    IRTS.JavaScript.Specialize IRTS.Lang IRTS.LangOpts IRTS.Portable
    IRTS.Simplified IRTS.System Idris.ASTUtils Idris.AbsSyntax
    Idris.AbsSyntaxTree Idris.Apropos Idris.CaseSplit Idris.Chaser
    Idris.CmdOptions Idris.Colours Idris.Completion Idris.Core.Binary
    Idris.Core.CaseTree Idris.Core.Constraints Idris.Core.DeepSeq
    Idris.Core.Elaborate Idris.Core.Evaluate Idris.Core.Execute
    Idris.Core.ProofState Idris.Core.ProofTerm Idris.Core.TT
    Idris.Core.Typecheck Idris.Core.Unify Idris.Core.WHNF
    Idris.Coverage Idris.DSL Idris.DataOpts Idris.DeepSeq
    Idris.Delaborate Idris.Directives Idris.Docs Idris.Docstrings
    Idris.Elab.AsPat Idris.Elab.Clause Idris.Elab.Data
    Idris.Elab.Implementation Idris.Elab.Interface Idris.Elab.Provider
    Idris.Elab.Quasiquote Idris.Elab.Record Idris.Elab.Rewrite
    Idris.Elab.RunElab Idris.Elab.Term Idris.Elab.Transform
    Idris.Elab.Type Idris.Elab.Utils Idris.Elab.Value Idris.ElabDecls
    Idris.Erasure Idris.ErrReverse Idris.Error Idris.Help Idris.IBC
    Idris.IdeMode Idris.IdrisDoc Idris.Imports Idris.Info
    Idris.Info.Show Idris.Inliner Idris.Interactive Idris.Main
    Idris.ModeCommon Idris.Options Idris.Output Idris.Package
    Idris.Package.Common Idris.Package.Parser Idris.Parser
    Idris.Parser.Data Idris.Parser.Expr Idris.Parser.Helpers
    Idris.Parser.Ops Idris.Parser.Stack Idris.PartialEval
    Idris.Primitives Idris.ProofSearch Idris.Prover Idris.Providers
    Idris.REPL Idris.REPL.Browse Idris.REPL.Commands Idris.REPL.Parser
    Idris.Reflection Idris.Termination Idris.Transforms
    Idris.TypeSearch Idris.Unlit Idris.WhoCalls Util.DynamicLinker
    Util.ScreenSize Util.System

hidden-modules:
    Util.Pretty Util.Net Paths_idris Version_idris Tools_idris
    BuildFlags_idris

import-dirs:          /usr/lib/ghc-8.10.5/site-local/idris-1.3.3
library-dirs:         /usr/lib/ghc-8.10.5/site-local/idris-1.3.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/idris
hs-libraries:         HSidris-1.3.3-72p9B9doRGfCFjoKtIRiXd
extra-libraries:      gmp
depends:
    aeson-1.5.6.0-CVfeYccFVpdCde0UrZZZdZ
    annotated-wl-pprint-0.7.0-LfvIEL94sD0ER9mdrVDak7
    ansi-terminal-0.11-366lZebL4UKAFopo4Q1x1i
    ansi-wl-pprint-0.6.9-18xfpSFHwXcSLsLHaSUhO array-0.5.4.0
    async-2.2.3-EEZ7ScAbhsHIRG0TBpna8H base-4.14.2.0
    base64-bytestring-1.2.0.1-9folcSD81CwJ7ibR6pZE7R binary-0.8.8.0
    blaze-html-0.9.1.2-3gWJOEFN3Rn7Mv2jAJdKwl
    blaze-markup-0.8.2.8-8RebaU3zReM4AoTFuL4PYs bytestring-0.10.12.0
    cheapskate-0.1.1.2-E95ctUO9FtDH9BKMGRuwR8
    code-page-0.2.1-3C62FJxRFEL4hMDYNXOvWB containers-0.6.4.1
    deepseq-1.4.4.0 directory-1.3.6.0 filepath-1.4.2.1
    fingertree-0.1.4.2-JrAehD370WF20WLAlnpJcY
    fsnotify-0.3.0.1-BpHOvLPFLhT7EOWhiom8nX haskeline-0.8.0.1
    ieee754-0.8.0-CHSaaJtgXtAIvy6hnwP5XY
    libffi-0.1-8U8n8AdfLs66HXhD0Pbsc9
    megaparsec-9.0.1-CgNxKp13Re58VqY3iga6b3 mtl-2.2.2
    network-3.1.2.2-5EE9GqQpTmvH0oBl8byO4M
    optparse-applicative-0.16.1.0-ARX6qDeExVWDKYrQ55nL8e
    parser-combinators-1.3.0-I56cvBuZMEG2VbjtPZAqZY pretty-1.1.3.6
    process-1.6.9.0 regex-tdfa-1.3.1.1-GKHvEQcFLVkJ8X6kzhWyIo
    safe-0.3.19-DlKvqLTtraZKItu5PR3KBM
    split-0.2.3.4-Fv3j3BhtJgT8PrdAoYtOLl
    terminal-size-0.3.2.1-8LMlp57ywuCIM7VIh4tqn1 text-1.2.4.1
    time-1.9.3 transformers-0.5.6.2
    uniplate-1.6.13-CG0RLAJFAqQ9pcfzpN03Lb unix-2.7.2.2
    unordered-containers-0.2.14.0-JpdjDmlqBJN4PAu3jIj4Ya
    utf8-string-1.0.2-DMovLmOdbFr3ZT2kNNb9Du
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp
    vector-binary-instances-0.2.5.2-5fEBRlLrHbJIGSRNZhKDtf
    zip-archive-0.4.1-8NGv2nxB6pDL75AFxe6s12

haddock-interfaces:   /usr/share/doc/idris/html/idris.haddock
haddock-html:         /usr/share/doc/idris/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

