/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.renderable;

import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import io.sf.carte.echosvg.ext.awt.image.renderable.AbstractRable;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.rendered.CachableRed;
import java.awt.color.ColorSpace;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.util.List;
import java.util.Map;

public abstract class AbstractColorInterpolationRable
extends AbstractRable {
    protected boolean csLinear = true;

    protected AbstractColorInterpolationRable() {
    }

    protected AbstractColorInterpolationRable(Filter filter) {
        super(filter);
    }

    protected AbstractColorInterpolationRable(Filter filter, Map<String, Object> map) {
        super(filter, map);
    }

    protected AbstractColorInterpolationRable(List<? extends RenderableImage> list) {
        super(list);
    }

    protected AbstractColorInterpolationRable(List<? extends RenderableImage> list, Map<String, Object> map) {
        super(list, map);
    }

    public boolean isColorSpaceLinear() {
        return this.csLinear;
    }

    public void setColorSpaceLinear(boolean bl) {
        this.touch();
        this.csLinear = bl;
    }

    public ColorSpace getOperationColorSpace() {
        if (this.csLinear) {
            return ColorSpace.getInstance(1004);
        }
        return ColorSpace.getInstance(1000);
    }

    protected CachableRed convertSourceCS(CachableRed cachableRed) {
        if (this.csLinear) {
            return GraphicsUtil.convertToLsRGB(cachableRed);
        }
        return GraphicsUtil.convertTosRGB(cachableRed);
    }

    protected CachableRed convertSourceCS(RenderedImage renderedImage) {
        return this.convertSourceCS(GraphicsUtil.wrap(renderedImage));
    }
}

