/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.Node;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class Block
extends AstNode {
    public Block() {
        this.type = 133;
    }

    public Block(int n) {
        super(n);
        this.type = 133;
    }

    public Block(int n, int n2) {
        super(n, n2);
        this.type = 133;
    }

    public void addStatement(AstNode astNode) {
        this.addChild(astNode);
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append("{\n");
        for (Node node : this) {
            AstNode astNode = (AstNode)node;
            stringBuilder.append(astNode.toSource(n + 1));
            if (astNode.getType() != 165) continue;
            stringBuilder.append("\n");
        }
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append("}");
        if (this.getInlineComment() != null) {
            stringBuilder.append(this.getInlineComment().toSource(n));
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            for (Node node : this) {
                ((AstNode)node).visit(nodeVisitor);
            }
        }
    }
}

