/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.curve.tess;

import com.jogamp.graph.curve.tess.Triangulator;
import com.jogamp.graph.geom.Outline;
import com.jogamp.graph.geom.Triangle;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.math.Vec2f;
import com.jogamp.math.VectorUtil;
import java.util.ArrayList;
import java.util.List;
import jogamp.graph.curve.tess.CDTriangulator2DExpAddOn;
import jogamp.graph.curve.tess.GraphOutline;
import jogamp.graph.curve.tess.GraphVertex;
import jogamp.graph.curve.tess.Loop;
import jogamp.opengl.Debug;

public class CDTriangulator2D
implements Triangulator {
    protected static final boolean DEBUG = Debug.debug("graph.curve.Triangulation");
    private static final boolean TEST_LINE_AA = Debug.debug("graph.curve.triangulation.LINE_AA");
    private static final boolean TEST_MARK_LINE = Debug.debug("graph.curve.triangulation.MARK_AA");
    private static final boolean TEST_ENABLED = TEST_LINE_AA || TEST_MARK_LINE;
    private final ArrayList<Loop> loops = new ArrayList();
    private boolean complexShape = false;
    private int addedVerticeCount;
    private int maxTriID;
    static final boolean FixedWindingRule = true;

    public CDTriangulator2D() {
        this.reset();
    }

    @Override
    public void setComplexShape(boolean bl) {
        this.complexShape = bl;
    }

    @Override
    public final void reset() {
        this.maxTriID = 0;
        this.addedVerticeCount = 0;
        this.loops.clear();
    }

    @Override
    public final int getAddedVerticeCount() {
        return this.addedVerticeCount;
    }

    @Override
    public final void addCurve(List<Triangle> list, Outline outline, float f) {
        Loop loop = this.getContainerLoop(outline);
        if (null == loop) {
            GraphOutline graphOutline = new GraphOutline(outline);
            GraphOutline graphOutline2 = this.extractBoundaryTriangles(list, graphOutline, false, f);
            if (graphOutline2.getGraphPoint().size() >= 3) {
                loop = Loop.createBoundary(graphOutline2, this.complexShape);
                if (null != loop) {
                    this.loops.add(loop);
                }
            } else if (DEBUG) {
                System.err.println("Drop innerPoly ctrlpts < 3");
                System.err.println("- innerPo[vertices " + graphOutline2.getOutline().getVertexCount() + ", ctrlpts " + graphOutline2.getGraphPoint().size() + "] < 3");
                System.err.println("- outline[vertices " + graphOutline.getOutline().getVertexCount() + ", ctrlpts " + graphOutline.getGraphPoint().size() + "]");
                System.err.println("-   Input[vertices " + outline.getVertexCount() + "]");
                Thread.dumpStack();
            }
        } else {
            GraphOutline graphOutline = new GraphOutline(outline);
            GraphOutline graphOutline3 = this.extractBoundaryTriangles(list, graphOutline, true, f);
            loop.addConstraintCurveHole(graphOutline3);
        }
    }

    @Override
    public final void generate(List<Triangle> list) {
        block8: {
            Vec2f vec2f;
            int n;
            Object object;
            block9: {
                int n2 = this.loops.size();
                for (int i = 0; i < n2; ++i) {
                    Triangle triangle;
                    object = this.loops.get(i);
                    n = 0;
                    int n3 = ((Loop)object).computeLoopSize();
                    while (!((Loop)object).isSimplex()) {
                        boolean bl;
                        if (n > n3) {
                            triangle = ((Loop)object).cut(false);
                            bl = false;
                        } else {
                            triangle = ((Loop)object).cut(true);
                            bl = true;
                        }
                        ++n;
                        if (triangle != null) {
                            triangle.setId(this.maxTriID++);
                            list.add(triangle);
                            if (DEBUG) {
                                System.err.println("CDTri.gen[" + i + "].0: delaunay " + bl + ", tries " + n + ", size " + n3 + ", " + triangle);
                            }
                            n = 0;
                            --n3;
                        }
                        if (n <= n3 * 2) continue;
                        if (!DEBUG) break;
                        System.err.println("CDTri.gen[" + i + "].X: Triangulation not complete!");
                        break;
                    }
                    if ((triangle = ((Loop)object).cut(true)) == null) continue;
                    triangle.setId(this.maxTriID++);
                    list.add(triangle);
                    if (!DEBUG) continue;
                    System.err.println("CDTri.gen[" + i + "].1: size " + n3 + "/" + n2 + ", " + triangle);
                }
                if (!TEST_ENABLED) break block8;
                vec2f = new Vec2f();
                object = new CDTriangulator2DExpAddOn();
                n = list.size();
                if (!TEST_MARK_LINE) break block9;
                for (int i = 0; i < n; ++i) {
                    Triangle triangle = list.get(i);
                    ((CDTriangulator2DExpAddOn)object).markLineInTriangle(triangle);
                }
                break block8;
            }
            if (!TEST_LINE_AA) break block8;
            for (int i = 0; i < n - 1; i += 2) {
                Triangle triangle = list.get(i);
                Triangle triangle2 = list.get(i + 1);
                ((CDTriangulator2DExpAddOn)object).processLineAA(i, triangle, triangle2, vec2f);
            }
        }
    }

    private GraphOutline extractBoundaryTriangles(List<Triangle> list, GraphOutline graphOutline, boolean bl, float f) {
        GraphOutline graphOutline2 = new GraphOutline();
        ArrayList<GraphVertex> arrayList = graphOutline.getGraphPoint();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            GraphVertex graphVertex = arrayList.get(i);
            GraphVertex graphVertex2 = arrayList.get((i + n - 1) % n);
            GraphVertex graphVertex3 = arrayList.get((i + 1) % n);
            if (!graphVertex.getPoint().isOnCurve()) {
                Triangle triangle;
                boolean bl2;
                Vertex vertex = graphVertex2.getPoint().copy();
                Vertex vertex2 = graphVertex3.getPoint().copy();
                Vertex vertex3 = graphVertex.getPoint().copy();
                this.addedVerticeCount += 3;
                boolean[] blArray = new boolean[]{true, true, true};
                graphVertex2.setBoundaryContained(true);
                graphVertex.setBoundaryContained(true);
                graphVertex3.setBoundaryContained(true);
                if (VectorUtil.isCCW(vertex, vertex3, vertex2)) {
                    bl2 = false;
                    triangle = new Triangle(vertex, vertex3, vertex2, blArray);
                } else {
                    bl2 = true;
                    triangle = new Triangle(vertex2, vertex3, vertex, blArray);
                }
                triangle.setId(this.maxTriID++);
                list.add(triangle);
                if (DEBUG) {
                    System.err.println(triangle);
                }
                if (bl || bl2) {
                    vertex.setTexCoord(0.0f, -0.1f, 0.0f);
                    vertex2.setTexCoord(1.0f, -0.1f, 0.0f);
                    vertex3.setTexCoord(0.5f, -f - 0.1f, 0.0f);
                    graphOutline2.addVertex(graphVertex);
                } else {
                    vertex.setTexCoord(0.0f, 0.1f, 0.0f);
                    vertex2.setTexCoord(1.0f, 0.1f, 0.0f);
                    vertex3.setTexCoord(0.5f, f + 0.1f, 0.0f);
                }
                if (!DEBUG) continue;
                System.err.println("CDTri.ebt[" + i + "].0: hole " + (bl || bl2) + " " + graphVertex + ", " + triangle);
                continue;
            }
            if (!graphVertex3.getPoint().isOnCurve() || !graphVertex2.getPoint().isOnCurve()) {
                graphVertex.setBoundaryContained(true);
            }
            graphOutline2.addVertex(graphVertex);
            if (!DEBUG) continue;
            System.err.println("CDTri.ebt[" + i + "].1: " + graphVertex);
        }
        return graphOutline2;
    }

    private Loop getContainerLoop(Outline outline) {
        int n = this.loops.size();
        if (0 < n) {
            ArrayList<Vertex> arrayList = outline.getVertices();
            for (int i = 0; i < n; ++i) {
                Loop loop = this.loops.get(i);
                for (int j = 0; j < arrayList.size(); ++j) {
                    if (!loop.checkInside(arrayList.get(j))) continue;
                    return loop;
                }
            }
        }
        return null;
    }
}

