/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.konan.serialization;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleSerializer;
import org.jetbrains.kotlin.backend.common.serialization.IrSerializationSettings;
import org.jetbrains.kotlin.backend.konan.serialization.KonanDeclarationTable;
import org.jetbrains.kotlin.backend.konan.serialization.KonanGlobalDeclarationTable;
import org.jetbrains.kotlin.backend.konan.serialization.KonanIrFileSerializer;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.declarations.IrFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/konan/serialization/KonanIrModuleSerializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleSerializer;", "Lorg/jetbrains/kotlin/backend/konan/serialization/KonanIrFileSerializer;", "settings", "Lorg/jetbrains/kotlin/backend/common/serialization/IrSerializationSettings;", "diagnosticReporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/serialization/IrSerializationSettings;Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;Lorg/jetbrains/kotlin/ir/IrBuiltIns;)V", "globalDeclarationTable", "Lorg/jetbrains/kotlin/backend/konan/serialization/KonanGlobalDeclarationTable;", "getGlobalDeclarationTable", "()Lorg/jetbrains/kotlin/backend/konan/serialization/KonanGlobalDeclarationTable;", "backendSpecificFileFilter", "", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "createSerializerForFile", "ir.serialization.native"})
public final class KonanIrModuleSerializer
extends IrModuleSerializer<KonanIrFileSerializer> {
    @NotNull
    private final KonanGlobalDeclarationTable globalDeclarationTable;

    public KonanIrModuleSerializer(@NotNull IrSerializationSettings settings, @NotNull IrDiagnosticReporter diagnosticReporter, @NotNull IrBuiltIns irBuiltIns) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)diagnosticReporter, (String)"diagnosticReporter");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        super(settings, diagnosticReporter);
        this.globalDeclarationTable = new KonanGlobalDeclarationTable(irBuiltIns, settings);
    }

    @Override
    @NotNull
    protected KonanGlobalDeclarationTable getGlobalDeclarationTable() {
        return this.globalDeclarationTable;
    }

    @Override
    protected boolean backendSpecificFileFilter(@NotNull IrFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return !Intrinsics.areEqual((Object)file.getFileEntry().getName(), (Object)"CTypeDefinitions");
    }

    @Override
    @NotNull
    public KonanIrFileSerializer createSerializerForFile(@NotNull IrFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new KonanIrFileSerializer(this.getSettings(), new KonanDeclarationTable(this.getGlobalDeclarationTable()));
    }
}

