/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.packagecache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.python.core.Py;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyStringMap;
import org.python.objectweb.asm.ClassReader;
import org.python.objectweb.asm.ClassVisitor;

public abstract class PackageManager {
    public PyJavaPackage topLevelPackage = new PyJavaPackage("", this);

    public abstract Class findClass(String var1, String var2, String var3);

    public Class findClass(String pkg, String name) {
        return this.findClass(pkg, name, "java class");
    }

    public void notifyPackageImport(String pkg, String name) {
    }

    public abstract boolean packageExists(String var1, String var2);

    public abstract PyList doDir(PyJavaPackage var1, boolean var2, boolean var3);

    public abstract void addDirectory(File var1);

    public abstract void addJarDir(String var1, boolean var2);

    public abstract void addJar(String var1, boolean var2);

    protected PyList basicDoDir(PyJavaPackage jpkg, boolean instantiate, boolean exclpkgs) {
        PyStringMap dict = jpkg.__dict__;
        PyStringMap cls = jpkg.clsSet;
        if (!instantiate) {
            PyList ret = cls.keys();
            PyList dictKeys = dict.keys();
            for (PyObject name : dictKeys.asIterable()) {
                if (cls.has_key(name) || exclpkgs && dict.get(name) instanceof PyJavaPackage) continue;
                ret.append(name);
            }
            return ret;
        }
        for (PyObject pyname : cls.keys().asIterable()) {
            if (dict.has_key(pyname)) continue;
            String name = pyname.toString();
            jpkg.addClass(name, Py.findClass(jpkg.__name__ + "." + name));
        }
        return dict.keys();
    }

    protected PyList merge(PyList list1, PyList list2) {
        for (PyObject name : list2.asIterable()) {
            list1.append(name);
        }
        return list1;
    }

    public PyObject lookupName(String name) {
        String lastName;
        PyObject top = this.topLevelPackage;
        do {
            int dot = name.indexOf(46);
            String firstName = name;
            lastName = null;
            if (dot != -1) {
                firstName = name.substring(0, dot);
                lastName = name.substring(dot + 1, name.length());
            }
            if ((top = top.__findattr__(firstName = firstName.intern())) != null) continue;
            return null;
        } while ((name = lastName) != null);
        return top;
    }

    public PyJavaPackage makeJavaPackage(String name, String classes, String jarfile) {
        PyJavaPackage p = this.topLevelPackage;
        if (name.length() != 0) {
            p = p.addPackage(name, jarfile);
        }
        p.addPlaceholders(PackageManager.split(classes, ",@"));
        return p;
    }

    protected static int checkAccess(InputStream cstream) throws IOException {
        try {
            ClassReader reader = new ClassReader(cstream);
            AccessVisitor visitor = new AccessVisitor();
            reader.accept(visitor, 0);
            return visitor.getClassAccess();
        }
        catch (RuntimeException e) {
            return -1;
        }
    }

    protected static Set<String> split(String target, String sep) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (target != null) {
            StringTokenizer tok = new StringTokenizer(target, sep);
            while (tok.hasMoreTokens()) {
                String entry = tok.nextToken().trim();
                if (entry.length() <= 0) continue;
                result.add(entry);
            }
        }
        return result;
    }

    protected static Set<String> split(String target) {
        return PackageManager.split(target, ",");
    }

    private static class AccessVisitor
    extends ClassVisitor {
        private int class_access;

        public AccessVisitor() throws IOException {
            super(458752);
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.class_access = access;
        }

        public int getClassAccess() {
            return this.class_access;
        }
    }
}

