/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.query;

import java.util.Objects;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.state.ValueAndTimestamp;

@InterfaceStability.Evolving
public final class TimestampedKeyQuery<K, V>
implements Query<ValueAndTimestamp<V>> {
    private final K key;
    private final boolean skipCache;

    private TimestampedKeyQuery(K key, boolean skipCache) {
        this.key = key;
        this.skipCache = skipCache;
    }

    public static <K, V> TimestampedKeyQuery<K, V> withKey(K key) {
        Objects.requireNonNull(key, "the key should not be null");
        return new TimestampedKeyQuery<K, V>(key, false);
    }

    public TimestampedKeyQuery<K, V> skipCache() {
        return new TimestampedKeyQuery<K, V>(this.key, true);
    }

    public K key() {
        return this.key;
    }

    public boolean isSkipCache() {
        return this.skipCache;
    }
}

