/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.type.ProcedureParameterExtractionAware;
import org.hibernate.type.descriptor.JdbcBindingLogging;
import org.hibernate.type.descriptor.JdbcExtractingLogging;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.UserType;

public class UserTypeSqlTypeAdapter<J>
implements JdbcType {
    private final UserType<J> userType;
    private final JavaType<J> jtd;
    private final ValueExtractor<J> valueExtractor;
    private final ValueBinder<J> valueBinder;

    public UserTypeSqlTypeAdapter(UserType<J> userType, JavaType<J> jtd, TypeConfiguration typeConfiguration) {
        this.userType = userType;
        this.jtd = jtd;
        this.valueExtractor = new ValueExtractorImpl<J>(userType, jtd);
        this.valueBinder = new ValueBinderImpl<J>(userType, typeConfiguration);
    }

    @Override
    public String getFriendlyName() {
        return "UserTypeSqlTypeAdapter(" + String.valueOf(this.userType) + ")";
    }

    @Override
    public int getJdbcTypeCode() {
        return this.userType.getSqlType();
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        assert (javaType.getJavaTypeClass() == null || this.jtd.getJavaTypeClass().isAssignableFrom(javaType.getJavaTypeClass()));
        return this.valueBinder;
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        assert (javaType.getJavaTypeClass() == null || javaType.getJavaTypeClass().isAssignableFrom(this.jtd.getJavaTypeClass()));
        return this.valueExtractor;
    }

    @Override
    public <T> JavaType<T> getJdbcRecommendedJavaTypeMapping(Integer length, Integer scale, TypeConfiguration typeConfiguration) {
        return this.jtd;
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        if (!(this.userType instanceof EnhancedUserType)) {
            throw new HibernateException(String.format("Could not create JdbcLiteralFormatter, UserType class [%s] did not implement %s", this.userType.getClass().getName(), EnhancedUserType.class.getName()));
        }
        EnhancedUserType type = (EnhancedUserType)this.userType;
        return (appender, value, dialect, wrapperOptions) -> appender.append(type.toSqlLiteral(value));
    }

    private static class ValueBinderImpl<J>
    implements ValueBinder<J> {
        private final UserType<J> userType;

        public ValueBinderImpl(UserType<J> userType, TypeConfiguration typeConfiguration) {
            this.userType = userType;
        }

        @Override
        public void bind(PreparedStatement st, J value, int index, WrapperOptions options) throws SQLException {
            if (JdbcBindingLogging.LOGGER.isTraceEnabled()) {
                if (value == null) {
                    JdbcBindingLogging.logNullBinding(index, this.userType.getSqlType());
                } else {
                    JdbcBindingLogging.logBinding(index, this.userType.getSqlType(), value);
                }
            }
            this.userType.nullSafeSet(st, value, index, options.getSession());
        }

        @Override
        public void bind(CallableStatement st, J value, String name, WrapperOptions options) throws SQLException {
            throw new UnsupportedOperationException("Using UserType for CallableStatement parameter binding not supported");
        }
    }

    private static class ValueExtractorImpl<J>
    implements ValueExtractor<J> {
        private final UserType<J> userType;
        private final JavaType<J> javaType;

        public ValueExtractorImpl(UserType<J> userType, JavaType<J> javaType) {
            this.userType = userType;
            this.javaType = javaType;
        }

        @Override
        public J extract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
            J extracted = this.userType.nullSafeGet(rs, paramIndex, options.getSession(), null);
            this.logExtracted(paramIndex, extracted);
            return extracted;
        }

        @Override
        public J extract(CallableStatement statement, int paramIndex, WrapperOptions options) throws SQLException {
            if (this.userType instanceof ProcedureParameterExtractionAware) {
                Object extracted = ((ProcedureParameterExtractionAware)((Object)this.userType)).extract(statement, paramIndex, options.getSession());
                this.logExtracted(paramIndex, extracted);
                return extracted;
            }
            throw new UnsupportedOperationException("UserType does not support reading CallableStatement parameter values: " + String.valueOf(this.userType));
        }

        @Override
        public J extract(CallableStatement statement, String paramName, WrapperOptions options) throws SQLException {
            if (this.userType instanceof ProcedureParameterExtractionAware) {
                Object extracted = ((ProcedureParameterExtractionAware)((Object)this.userType)).extract(statement, paramName, options.getSession());
                this.logExtracted(paramName, extracted);
                return extracted;
            }
            throw new UnsupportedOperationException("UserType does not support reading CallableStatement parameter values: " + String.valueOf(this.userType));
        }

        private void logExtracted(int paramIndex, J extracted) {
            if (!JdbcExtractingLogging.LOGGER.isTraceEnabled()) {
                return;
            }
            if (extracted == null) {
                JdbcExtractingLogging.logNullExtracted(paramIndex, this.userType.getSqlType());
            } else {
                JdbcExtractingLogging.logExtracted(paramIndex, this.userType.getSqlType(), extracted);
            }
        }

        private void logExtracted(String paramName, J extracted) {
            if (!JdbcExtractingLogging.LOGGER.isTraceEnabled()) {
                return;
            }
            if (extracted == null) {
                JdbcExtractingLogging.logNullExtracted(paramName, this.userType.getSqlType());
            } else {
                JdbcExtractingLogging.logExtracted(paramName, this.userType.getSqlType(), extracted);
            }
        }
    }
}

