/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.ObjectDeletedException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.internal.AbstractSaveEventListener;
import org.hibernate.event.internal.EntityState;
import org.hibernate.event.internal.EventUtil;
import org.hibernate.event.internal.WrapVisitor;
import org.hibernate.event.spi.EntityCopyObserver;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.MergeContext;
import org.hibernate.event.spi.MergeEvent;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.ast.spi.CascadingFetchProfile;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.AnyType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;

public class DefaultMergeEventListener
extends AbstractSaveEventListener<MergeContext>
implements MergeEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultMergeEventListener.class);

    @Override
    protected Map<Object, Object> getMergeMap(MergeContext context) {
        return context.invertMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMerge(MergeEvent event) throws HibernateException {
        EventSource session = event.getSession();
        EntityCopyObserver entityCopyObserver = session.getFactory().getEntityCopyObserver().createEntityCopyObserver();
        MergeContext mergeContext = new MergeContext(session, entityCopyObserver);
        try {
            this.onMerge(event, mergeContext);
            entityCopyObserver.topLevelMergeComplete(session);
        }
        finally {
            entityCopyObserver.clear();
            mergeContext.clear();
        }
    }

    @Override
    public void onMerge(MergeEvent event, MergeContext copiedAlready) throws HibernateException {
        Object original = event.getOriginal();
        if (original != null) {
            EventSource source = event.getSession();
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(original);
            if (lazyInitializer != null) {
                if (lazyInitializer.isUninitialized()) {
                    LOG.trace("Ignoring uninitialized proxy");
                    event.setResult(source.getReference(lazyInitializer.getEntityName(), lazyInitializer.getInternalIdentifier()));
                } else {
                    this.doMerge(event, copiedAlready, lazyInitializer.getImplementation());
                }
            } else if (ManagedTypeHelper.isPersistentAttributeInterceptable(original)) {
                PersistentAttributeInterceptor interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(original).$$_hibernate_getInterceptor();
                if (interceptor instanceof EnhancementAsProxyLazinessInterceptor) {
                    EnhancementAsProxyLazinessInterceptor proxyInterceptor = (EnhancementAsProxyLazinessInterceptor)interceptor;
                    LOG.trace("Ignoring uninitialized enhanced proxy");
                    event.setResult(source.byId(proxyInterceptor.getEntityName()).getReference(proxyInterceptor.getIdentifier()));
                } else {
                    this.doMerge(event, copiedAlready, original);
                }
            } else {
                this.doMerge(event, copiedAlready, original);
            }
        }
    }

    private void doMerge(MergeEvent event, MergeContext copiedAlready, Object entity) {
        if (copiedAlready.containsKey(entity) && copiedAlready.isOperatedOn(entity)) {
            LOG.trace("Already in merge process");
            event.setResult(entity);
        } else {
            if (copiedAlready.containsKey(entity)) {
                LOG.trace("Already in copyCache; setting in merge process");
                copiedAlready.setOperatedOn(entity, true);
            }
            event.setEntity(entity);
            this.merge(event, copiedAlready, entity);
        }
    }

    private void merge(MergeEvent event, MergeContext copiedAlready, Object entity) {
        EntityState entityState;
        Object copiedId;
        Object originalId;
        EntityPersister persister;
        EventSource source = event.getSession();
        String entityName = event.getEntityName();
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        EntityEntry entry = persistenceContext.getEntry(entity);
        if (entry == null) {
            persister = source.getEntityPersister(entityName, entity);
            originalId = persister.getIdentifier(entity, copiedAlready);
            if (originalId != null) {
                EntityKey entityKey;
                Type type = persister.getIdentifierType();
                if (type instanceof ComponentType) {
                    ComponentType compositeId = (ComponentType)type;
                    copiedId = DefaultMergeEventListener.copyCompositeTypeId(originalId, compositeId, source, copiedAlready);
                    entityKey = source.generateEntityKey(copiedId, persister);
                } else {
                    copiedId = null;
                    entityKey = source.generateEntityKey(originalId, persister);
                }
                Object managedEntity = persistenceContext.getEntity(entityKey);
                entry = persistenceContext.getEntry(managedEntity);
                entityState = entry != null ? EntityState.DETACHED : EntityState.getEntityState(entity, entityName, entry, source, false);
            } else {
                copiedId = null;
                entityState = EntityState.getEntityState(entity, entityName, entry, source, false);
            }
        } else {
            copiedId = null;
            originalId = null;
            entityState = EntityState.getEntityState(entity, entityName, entry, source, false);
        }
        switch (entityState) {
            case DETACHED: {
                this.entityIsDetached(event, copiedId, originalId, copiedAlready);
                break;
            }
            case TRANSIENT: {
                this.entityIsTransient(event, copiedId != null ? copiedId : originalId, copiedAlready);
                break;
            }
            case PERSISTENT: {
                this.entityIsPersistent(event, copiedAlready);
                break;
            }
            default: {
                if (persistenceContext.getEntry(entity) == null) {
                    persister = source.getEntityPersister(entityName, entity);
                    assert (persistenceContext.containsDeletedUnloadedEntityKey(source.generateEntityKey(persister.getIdentifier(entity, event.getSession()), persister)));
                    source.getActionQueue().unScheduleUnloadedDeletion(entity);
                    this.entityIsDetached(event, copiedId, originalId, copiedAlready);
                    break;
                }
                throw new ObjectDeletedException("deleted instance passed to merge", originalId, EventUtil.getLoggableName(entityName, entity));
            }
        }
    }

    private static Object copyCompositeTypeId(Object id, CompositeType compositeType, EventSource session, MergeContext mergeContext) {
        SessionFactoryImplementor factory = session.getSessionFactory();
        Object idCopy = compositeType.deepCopy(id, factory);
        Type[] subtypes = compositeType.getSubtypes();
        Object[] propertyValues = compositeType.getPropertyValues(id);
        Object[] copiedValues = compositeType.getPropertyValues(idCopy);
        for (int i = 0; i < subtypes.length; ++i) {
            copiedValues[i] = DefaultMergeEventListener.copy(session, mergeContext, subtypes[i], propertyValues[i], factory);
        }
        return compositeType.replacePropertyValues(idCopy, copiedValues, session);
    }

    private static Object copy(EventSource session, MergeContext mergeContext, Type subtype, Object propertyValue, SessionFactoryImplementor factory) {
        if (subtype instanceof EntityType) {
            Object object = mergeContext.get(propertyValue);
            return object == null ? subtype.deepCopy(propertyValue, factory) : object;
        }
        if (subtype instanceof AnyType) {
            AnyType anyType = (AnyType)subtype;
            return DefaultMergeEventListener.copyCompositeTypeId(propertyValue, anyType, session, mergeContext);
        }
        if (subtype instanceof ComponentType) {
            ComponentType componentType = (ComponentType)subtype;
            return DefaultMergeEventListener.copyCompositeTypeId(propertyValue, componentType, session, mergeContext);
        }
        return subtype.deepCopy(propertyValue, factory);
    }

    protected void entityIsPersistent(MergeEvent event, MergeContext copyCache) {
        LOG.trace("Ignoring persistent instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        copyCache.put(entity, entity, true);
        this.cascadeOnMerge(source, persister, entity, copyCache);
        TypeHelper.replace(persister, entity, source, entity, copyCache);
        event.setResult(entity);
    }

    protected void entityIsTransient(MergeEvent event, Object id, MergeContext copyCache) {
        PersistentAttributeInterceptor attributeInterceptor;
        LOG.trace("Merging transient instance");
        Object entity = event.getEntity();
        EventSource session = event.getSession();
        Interceptor interceptor = session.getInterceptor();
        String entityName = event.getEntityName();
        EntityPersister persister = session.getEntityPersister(entityName, entity);
        String[] propertyNames = persister.getPropertyNames();
        Type[] propertyTypes = persister.getPropertyTypes();
        Object copy = DefaultMergeEventListener.copyEntity(copyCache, entity, session, persister, id);
        super.cascadeBeforeSave(session, persister, entity, copyCache);
        Object[] sourceValues = persister.getValues(entity);
        interceptor.preMerge(entity, sourceValues, propertyNames, propertyTypes);
        Object[] copiedValues = TypeHelper.replace(sourceValues, persister.getValues(copy), propertyTypes, session, copy, copyCache, ForeignKeyDirection.FROM_PARENT);
        persister.setValues(copy, copiedValues);
        this.saveTransientEntity(copy, entityName, event.getRequestedId(), session, copyCache);
        super.cascadeAfterSave(session, persister, entity, copyCache);
        Object[] targetValues = TypeHelper.replaceAssociations(sourceValues, persister.getValues(copy), propertyTypes, session, copy, copyCache, ForeignKeyDirection.TO_PARENT);
        persister.setValues(copy, targetValues);
        interceptor.postMerge(entity, copy, id, targetValues, null, propertyNames, propertyTypes);
        new CollectionVisitor(copy, id, session).processEntityPropertyValues(persister.getPropertyValuesToInsert(copy, this.getMergeMap(copyCache), session), persister.getPropertyTypes());
        event.setResult(copy);
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(copy) && (attributeInterceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(copy).$$_hibernate_getInterceptor()) == null) {
            persister.getBytecodeEnhancementMetadata().injectInterceptor(copy, id, (SharedSessionContractImplementor)session);
        }
    }

    private static Object copyEntity(MergeContext copyCache, Object entity, EventSource session, EntityPersister persister, Object id) {
        Object existingCopy = copyCache.get(entity);
        if (existingCopy != null) {
            persister.setIdentifier(existingCopy, id, session);
            return existingCopy;
        }
        Object copy = session.instantiate(persister, id);
        copyCache.put(entity, copy, true);
        return copy;
    }

    private void saveTransientEntity(Object entity, String entityName, Object requestedId, EventSource source, MergeContext copyCache) {
        if (requestedId == null) {
            this.saveWithGeneratedId(entity, entityName, copyCache, source, false);
        } else {
            this.saveWithRequestedId(entity, requestedId, entityName, copyCache, source);
        }
    }

    protected void entityIsDetached(MergeEvent event, Object copiedId, Object originalId, MergeContext copyCache) {
        LOG.trace("Merging detached instance");
        Object entity = event.getEntity();
        EventSource session = event.getSession();
        EntityPersister persister = session.getEntityPersister(event.getEntityName(), entity);
        String entityName = persister.getEntityName();
        if (originalId == null) {
            originalId = persister.getIdentifier(entity, session);
        }
        Object clonedIdentifier = copiedId == null ? persister.getIdentifierType().deepCopy(originalId, event.getFactory()) : copiedId;
        Object id = DefaultMergeEventListener.getDetachedEntityId(event, originalId, persister);
        Object result = session.getLoadQueryInfluencers().fromInternalFetchProfile(CascadingFetchProfile.MERGE, () -> session.get(entityName, clonedIdentifier));
        if (result == null) {
            LOG.trace("Detached instance not found in database");
            Boolean knownTransient = persister.isTransient(entity, session);
            if (knownTransient == Boolean.FALSE) {
                throw new StaleObjectStateException(entityName, id);
            }
            this.entityIsTransient(event, clonedIdentifier, copyCache);
        } else {
            copyCache.put(entity, result, true);
            Object target = DefaultMergeEventListener.targetEntity(event, entity, persister, id, result);
            this.cascadeOnMerge(session, persister, entity, copyCache);
            Interceptor interceptor = session.getInterceptor();
            String[] propertyNames = persister.getPropertyNames();
            Type[] propertyTypes = persister.getPropertyTypes();
            Object[] sourceValues = persister.getValues(entity);
            Object[] originalValues = persister.getValues(target);
            interceptor.preMerge(entity, sourceValues, propertyNames, propertyTypes);
            Object[] targetValues = TypeHelper.replace(sourceValues, originalValues, propertyTypes, session, target, copyCache);
            persister.setValues(target, targetValues);
            interceptor.postMerge(entity, target, id, targetValues, originalValues, propertyNames, propertyTypes);
            DefaultMergeEventListener.markInterceptorDirty(entity, target);
            event.setResult(result);
        }
    }

    private static Object targetEntity(MergeEvent event, Object entity, EntityPersister persister, Object id, Object result) {
        EventSource source = event.getSession();
        String entityName = persister.getEntityName();
        Object target = DefaultMergeEventListener.unproxyManagedForDetachedMerging(entity, result, persister, source);
        if (target == entity) {
            throw new AssertionFailure("entity was not detached");
        }
        if (!source.getEntityName(target).equals(entityName)) {
            throw new WrongClassException("class of the given object did not match class of persistent copy", event.getRequestedId(), entityName);
        }
        if (DefaultMergeEventListener.isVersionChanged(entity, source, persister, target)) {
            StatisticsImplementor statistics = source.getFactory().getStatistics();
            if (statistics.isStatisticsEnabled()) {
                statistics.optimisticFailure(entityName);
            }
            throw new StaleObjectStateException(entityName, id);
        }
        return target;
    }

    private static Object getDetachedEntityId(MergeEvent event, Object originalId, EntityPersister persister) {
        EventSource source = event.getSession();
        Object id = event.getRequestedId();
        if (id == null) {
            return originalId;
        }
        if (!persister.getIdentifierType().isEqual(id, originalId, (SessionFactoryImplementor)source.getFactory())) {
            throw new HibernateException("merge requested with id not matching id of passed entity");
        }
        return id;
    }

    private static Object unproxyManagedForDetachedMerging(Object incoming, Object managed, EntityPersister persister, EventSource source) {
        if (ManagedTypeHelper.isHibernateProxy(managed)) {
            return source.getPersistenceContextInternal().unproxy(managed);
        }
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(incoming) && persister.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading()) {
            PersistentAttributeInterceptor incomingInterceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(incoming).$$_hibernate_getInterceptor();
            PersistentAttributeInterceptor managedInterceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(managed).$$_hibernate_getInterceptor();
            if (!(managedInterceptor instanceof EnhancementAsProxyLazinessInterceptor)) {
                return managed;
            }
            if (incomingInterceptor instanceof EnhancementAsProxyLazinessInterceptor) {
                return managed;
            }
            persister.initializeEnhancedEntityUsedAsProxy(managed, null, source);
        }
        return managed;
    }

    private static void markInterceptorDirty(Object entity, Object target) {
        if (ManagedTypeHelper.isSelfDirtinessTracker(entity) && ManagedTypeHelper.isSelfDirtinessTracker(target)) {
            ManagedEntity managedEntity = ManagedTypeHelper.asManagedEntity(target);
            SelfDirtinessTracker selfDirtinessTrackerTarget = ManagedTypeHelper.asSelfDirtinessTracker(target);
            if (!selfDirtinessTrackerTarget.$$_hibernate_hasDirtyAttributes() && !ManagedTypeHelper.asManagedEntity(entity).$$_hibernate_useTracker()) {
                managedEntity.$$_hibernate_setUseTracker(false);
            } else {
                managedEntity.$$_hibernate_setUseTracker(true);
                selfDirtinessTrackerTarget.$$_hibernate_clearDirtyAttributes();
                for (String fieldName : ManagedTypeHelper.asSelfDirtinessTracker(entity).$$_hibernate_getDirtyAttributes()) {
                    selfDirtinessTrackerTarget.$$_hibernate_trackChange(fieldName);
                }
            }
        }
    }

    private static boolean isVersionChanged(Object entity, EventSource source, EntityPersister persister, Object target) {
        if (persister.isVersioned()) {
            boolean changed = !persister.getVersionType().isSame(persister.getVersion(target), persister.getVersion(entity));
            return changed && DefaultMergeEventListener.existsInDatabase(target, source, persister);
        }
        return false;
    }

    private static boolean existsInDatabase(Object entity, EventSource source, EntityPersister persister) {
        Object id;
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        EntityEntry entry = persistenceContext.getEntry(entity);
        if (entry == null && (id = persister.getIdentifier(entity, source)) != null) {
            EntityKey key = source.generateEntityKey(id, persister);
            Object managedEntity = persistenceContext.getEntity(key);
            entry = persistenceContext.getEntry(managedEntity);
        }
        return entry != null && entry.isExistsInDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeOnMerge(EventSource source, EntityPersister persister, Object entity, MergeContext copyCache) {
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        persistenceContext.incrementCascadeLevel();
        try {
            Cascade.cascade(this.getCascadeAction(), CascadePoint.BEFORE_MERGE, source, persister, entity, copyCache);
        }
        finally {
            persistenceContext.decrementCascadeLevel();
        }
    }

    @Override
    protected CascadingAction<MergeContext> getCascadeAction() {
        return CascadingActions.MERGE;
    }

    @Override
    protected void cascadeAfterSave(EventSource source, EntityPersister persister, Object entity, MergeContext anything) throws HibernateException {
    }

    @Override
    protected void cascadeBeforeSave(EventSource source, EntityPersister persister, Object entity, MergeContext anything) throws HibernateException {
    }

    private static class CollectionVisitor
    extends WrapVisitor {
        CollectionVisitor(Object entity, Object id, EventSource session) {
            super(entity, id, session);
        }

        @Override
        protected Object processCollection(Object collection, CollectionType collectionType) {
            if (collection instanceof PersistentCollection) {
                PersistentCollection persistentCollection = (PersistentCollection)collection;
                CollectionPersister persister = this.getSession().getFactory().getMappingMetamodel().getCollectionDescriptor(collectionType.getRole());
                CollectionEntry collectionEntry = this.getSession().getPersistenceContextInternal().getCollectionEntry(persistentCollection);
                if (!persistentCollection.equalsSnapshot(persister)) {
                    collectionEntry.resetStoredSnapshot(persistentCollection, persistentCollection.getSnapshot(persister));
                }
            }
            return null;
        }

        @Override
        Object processEntity(Object value, EntityType entityType) {
            return null;
        }
    }
}

