/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.internal.ParameterMarkerStrategyStandard;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

public abstract class AbstractNoOffsetLimitHandler
extends AbstractLimitHandler {
    private final boolean variableLimit;

    public AbstractNoOffsetLimitHandler(boolean variableLimit) {
        this.variableLimit = variableLimit;
    }

    protected abstract String limitClause();

    protected String limitClause(int jdbcParameterCount, ParameterMarkerStrategy parameterMarkerStrategy) {
        return this.limitClause();
    }

    protected abstract String insert(String var1, String var2);

    @Override
    public String processSql(String sql, int jdbcParameterCount, @Nullable ParameterMarkerStrategy parameterMarkerStrategy, QueryOptions queryOptions) {
        return this.processSql(sql, jdbcParameterCount, parameterMarkerStrategy, queryOptions.getLimit());
    }

    @Override
    public String processSql(String sql, Limit limit) {
        return this.processSql(sql, -1, null, limit);
    }

    private String processSql(String sql, int jdbcParameterCount, @Nullable ParameterMarkerStrategy parameterMarkerStrategy, @Nullable Limit limit) {
        String limitClause;
        if (!AbstractNoOffsetLimitHandler.hasMaxRows(limit)) {
            return sql;
        }
        String string = limitClause = ParameterMarkerStrategyStandard.isStandardRenderer(parameterMarkerStrategy) || !this.supportsVariableLimit() ? this.limitClause() : this.limitClause(jdbcParameterCount, parameterMarkerStrategy);
        if (!this.supportsVariableLimit()) {
            String limitLiteral = String.valueOf(this.getMaxOrLimit(limit));
            limitClause = limitClause.replace("?", limitLiteral);
        }
        return this.insert(limitClause, sql);
    }

    @Override
    public final boolean supportsLimit() {
        return true;
    }

    @Override
    public final boolean supportsLimitOffset() {
        return false;
    }

    @Override
    public final boolean supportsVariableLimit() {
        return this.variableLimit;
    }

    @Override
    public abstract boolean bindLimitParametersFirst();
}

