/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp;

import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionLabelingCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalConnectionPoolLifeCycleState;
import oracle.ucp.UniversalConnectionPoolStatistics;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.diagnostics.Diagnosable;

public interface UniversalConnectionPool
extends Diagnosable {
    public UniversalPooledConnection borrowConnection(ConnectionRetrievalInfo var1) throws UniversalConnectionPoolException;

    default public CompletionStage<UniversalPooledConnection> borrowConnectionAsync(ConnectionRetrievalInfo cri, Executor executor) throws UnsupportedOperationException {
        throw new NoSuchMethodError();
    }

    public void returnConnection(UniversalPooledConnection var1) throws UniversalConnectionPoolException;

    public void closeConnection(UniversalPooledConnection var1) throws UniversalConnectionPoolException;

    public void refresh() throws UniversalConnectionPoolException;

    public void recycle() throws UniversalConnectionPoolException;

    public void purge() throws UniversalConnectionPoolException;

    public void reconfigure(Properties var1) throws UniversalConnectionPoolException;

    public void start(ConnectionRetrievalInfo var1, boolean var2) throws UniversalConnectionPoolException;

    default public void start() throws UniversalConnectionPoolException {
        this.start(this.getConnectionRetrievalInfo(), false);
    }

    public void stop() throws UniversalConnectionPoolException;

    public String getName();

    public void setName(String var1);

    public int getInitialPoolSize();

    public void setInitialPoolSize(int var1) throws UniversalConnectionPoolException;

    public int getMinPoolSize();

    public void setMinPoolSize(int var1) throws UniversalConnectionPoolException;

    public int getMinIdle();

    public void setMinIdle(int var1) throws UniversalConnectionPoolException;

    public int getMaxPoolSize();

    public void setMaxPoolSize(int var1) throws UniversalConnectionPoolException;

    public int getInactiveConnectionTimeout();

    public void setInactiveConnectionTimeout(int var1) throws UniversalConnectionPoolException;

    public int getAbandonedConnectionTimeout();

    public void setAbandonedConnectionTimeout(int var1) throws UniversalConnectionPoolException;

    @Deprecated
    public int getConnectionWaitTimeout();

    public Duration getConnectionWaitDuration();

    @Deprecated
    public void setConnectionWaitTimeout(int var1) throws UniversalConnectionPoolException;

    public void setConnectionWaitDuration(Duration var1) throws UniversalConnectionPoolException;

    public int getTimeToLiveConnectionTimeout();

    public void setTimeToLiveConnectionTimeout(int var1) throws UniversalConnectionPoolException;

    public int getTimeoutCheckInterval();

    public void setTimeoutCheckInterval(int var1) throws UniversalConnectionPoolException;

    public boolean getValidateConnectionOnBorrow();

    public void setValidateConnectionOnBorrow(boolean var1);

    public int getConnectionHarvestTriggerCount();

    public void setConnectionHarvestTriggerCount(int var1) throws UniversalConnectionPoolException;

    public int getConnectionHarvestMaxCount();

    public void setConnectionHarvestMaxCount(int var1) throws UniversalConnectionPoolException;

    public int getAvailableConnectionsCount();

    public int getBorrowedConnectionsCount();

    public UniversalConnectionPoolStatistics getStatistics();

    public UniversalConnectionPoolLifeCycleState getLifeCycleState();

    public ConnectionRetrievalInfo getConnectionRetrievalInfo();

    public void setConnectionRetrievalInfo(ConnectionRetrievalInfo var1);

    public void registerConnectionAffinityCallback(ConnectionAffinityCallback var1) throws UniversalConnectionPoolException;

    public void removeConnectionAffinityCallback() throws UniversalConnectionPoolException;

    public void registerConnectionLabelingCallback(ConnectionLabelingCallback var1) throws UniversalConnectionPoolException;

    public void removeConnectionLabelingCallback() throws UniversalConnectionPoolException;

    public long getMaxConnectionReuseTime();

    public void setMaxConnectionReuseTime(long var1) throws UniversalConnectionPoolException;

    public int getMaxConnectionReuseCount();

    public void setMaxConnectionReuseCount(int var1) throws UniversalConnectionPoolException;

    public int getSecondsToTrustIdleConnection();

    public void setSecondsToTrustIdleConnection(int var1) throws UniversalConnectionPoolException;

    public int getConnectionLabelingHighCost();

    public void setConnectionLabelingHighCost(int var1) throws UniversalConnectionPoolException;

    public int getHighCostConnectionReuseThreshold();

    public void setHighCostConnectionReuseThreshold(int var1) throws UniversalConnectionPoolException;

    public int getMaxConnectionsPerService();

    public void setMaxConnectionsPerService(int var1) throws UniversalConnectionPoolException;

    public int getConnectionRepurposeThreshold();

    public void setConnectionRepurposeThreshold(Integer var1) throws UniversalConnectionPoolException;

    public int getLoginTimeout();

    public void setLoginTimeout(int var1) throws UniversalConnectionPoolException;

    public boolean isShareable();

    public void setShardingMode(boolean var1);

    public boolean getShardingMode();

    public void setConnectionValidationTimeout(int var1) throws UniversalConnectionPoolException;

    public int getConnectionValidationTimeout();

    public boolean isReadOnlyInstanceAllowed();

    public void setReadOnlyInstanceAllowed(boolean var1);

    public boolean isCommitOnConnectionReturn();

    public void setCommitOnConnectionReturn(boolean var1);
}

