/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.BuildVersion;
import com.ibm.db2.cmx.runtime.internal.JccFeature;
import com.ibm.db2.cmx.runtime.internal.XmlFormatNotSupported;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.license.ExtendedInsightLicense;
import com.ibm.db2.cmx.runtime.license.ExtendedInsightZosLicense;
import com.ibm.db2.cmx.runtime.license.License;
import com.ibm.db2.cmx.tools.DataVersion;
import com.ibm.db2.jcc.DB2Connection;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Configuration {
    public static final String pdqProductNameFull__ = "IBM InfoSphere Optim pureQuery Runtime";
    public static final String pdqProductNamePartial__ = "pureQuery Runtime";
    public static final String jccProductName__ = "IBM Data Server Driver for JDBC and SQLJ";
    public static final String dsProductName__ = "IBM Data Studio";
    public static final String db2ForZOSProductName__ = "IBM DB2 for z/OS";
    public static final String db2ForLUWProductName__ = "IBM DB2 Database for Linux, UNIX, and Windows";
    public static final String db2ForIBMiProductName__ = "IBM DB2 for IBM i";
    public static final String oqwtProductName__ = "IBM InfoSphere Optim Query Workload Tuner";
    public static final String oqwtXMLSchema__ = "InfoSphere Optim Query Workload Tuner";
    private static final String copyrightNotice__ = "Licensed Materials - Property of IBM\n5724-X84\n(c) Copyright IBM Corp. 2006, 2018 All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with\nIBM Corp.";
    private static final String copyrightNoticeForCommandLineOutput__ = "Licensed Materials - Property of IBM\n5724-X84\n(c) Copyright IBM Corp. 2006, 2018 All Rights Reserved.";
    public static final String dataStudioVersion__ = "3.3.0.6";
    public static boolean isLicensed__;
    public static boolean isExtendedInsightLicensed__;
    public static boolean isExtendedInsightLUWLicensed__;
    public static boolean isExtendedInsightZosLicensed__;
    public static boolean isJCCPresent__;
    public static boolean isJCCAtPrerequisiteLevel__;
    public static boolean isJCCAtEI3ProtocolLevel__;
    public static boolean isJCCAtCMX5ProtocolLevel__;
    public static boolean isJCCAtCMX9ProtocolLevel__;
    public static boolean isMonitorSPSupported__;
    public static String JCCVersionAsString__;
    public static int JCCMajorVersion__;
    public static int JCCMinorVersion__;
    public static int JCCBuildNumber__;
    public static String JCCDriverName__;
    public static int JCCReleaseCertification__;
    public static final int JCC3PrereqMajorVersion__ = 3;
    public static final int JCC3PrereqMinorVersion__ = 57;
    public static final int JCC4PrereqMajorVersion__ = 4;
    public static final int JCC4PrereqMinorVersion__ = 7;
    public static final String JCC3PrereqAsString__ = "3.57";
    public static final String JCC4PrereqAsString__ = "4.7";
    public static String jccDriverPath__;
    public static String pureQueryDriverPath__;
    public static final String xmlSchemaVersion__ = "4";
    public static String localHostAddress__;
    public static String[] myHostAddresses__;
    public static int extendedInsightMonitorProtocolClientMaxLevel__;
    public static int extendedInsightControllerProtocolClientMaxLevel__;
    public static final int JCC_FEATURE_STATIC_CO_AGK_FOR_UDM_USING_COLUMN_NAMES__ = 0;
    public static final int JCC_FEATURE_DBTimestamp_CLASS__ = 1;
    public static final int JCC_FEATURE_DAO_getObject_SUPPORT__ = 2;
    public static final String DAO_getObject_SUPPORT_VERSION__ = "4.18";
    public static final int JCC_FEATURE_CORR_TOKEN_SUPPORT__ = 3;
    public static final int JCC_FEATURE_COUNT__ = 4;
    private static final JccFeature[] jccFeatures__;

    private static void loadLicense() {
        try {
            isLicensed__ = Configuration.isLicensedX();
        }
        catch (Throwable throwable) {
            isLicensed__ = false;
        }
        try {
            isExtendedInsightLUWLicensed__ = Configuration.isExtendedInsightLUWLicensedX();
        }
        catch (Throwable throwable) {
            isExtendedInsightLUWLicensed__ = false;
        }
        try {
            isExtendedInsightZosLicensed__ = Configuration.isExtendedInsightZosLicensedX();
        }
        catch (Throwable throwable) {
            isExtendedInsightZosLicensed__ = false;
        }
        isExtendedInsightLicensed__ = isExtendedInsightLUWLicensed__ || isExtendedInsightZosLicensed__;
    }

    private static boolean isLicensedX() {
        return License.isLicensed();
    }

    private static void loadLocalHostAddresses() {
        Logger logger;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String[] stringArray = null;
        LinkedHashSet linkedHashSet = null;
        try {
            logger = Log.getGlobalLogger();
            InetAddress inetAddress = InetAddress.getLocalHost();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Discovered local host :" + inetAddress.getHostAddress());
            }
            if (Configuration.meetsGlobalAddressRequirements(inetAddress)) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Added local host :" + inetAddress.getHostAddress());
                }
                arrayList.add(inetAddress.getHostAddress());
            }
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress2 = enumeration2.nextElement();
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Discovered network interface:" + inetAddress2.getHostAddress());
                    }
                    if (Configuration.meetsGlobalAddressRequirements(inetAddress2)) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.log(Level.FINEST, "Added network interface:" + inetAddress2.getHostAddress());
                        }
                        arrayList.add(inetAddress2.getHostAddress());
                        continue;
                    }
                    if (!Configuration.meetsLocalAddressRequirements(inetAddress2)) continue;
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Added local network interface:" + inetAddress2.getHostAddress());
                    }
                    arrayList2.add(inetAddress2.getHostAddress());
                }
            }
        }
        catch (Exception exception) {
            Logger logger2 = Log.getGlobalLogger();
            DataLogger.lowImpactLogger(logger2, Configuration.class, "loadLocalHostAddresses", "Unable to obtain localhost ipaddress ", exception);
            ExceptionFactory.logException(logger2, (Throwable)exception);
        }
        arrayList.addAll(arrayList2);
        linkedHashSet = new LinkedHashSet(arrayList);
        arrayList.clear();
        arrayList.addAll(linkedHashSet);
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        myHostAddresses__ = stringArray;
        if (myHostAddresses__ != null && myHostAddresses__.length > 0) {
            localHostAddress__ = myHostAddresses__[0];
        }
        logger = Log.getGlobalLogger();
        Configuration.traceMonitorIPs(logger, "loadLocalHostAddresses", myHostAddresses__);
    }

    public static void traceMonitorIPs(Logger logger, String string, String[] stringArray) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, string + ":Monitor host array :" + Arrays.toString(stringArray) + " Local host address :" + localHostAddress__);
        }
    }

    public static String resolveToIPAddress(String string) {
        String string2 = string;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            string2 = inetAddress.isLoopbackAddress() ? localHostAddress__ : inetAddress.getHostAddress();
        }
        catch (Exception exception) {
            Logger logger = Log.getGlobalLogger();
            DataLogger.lowImpactLogger(logger, Configuration.class, "resolveToIPAddress", "Unable to obtain ipaddress for host string " + string, exception);
            ExceptionFactory.logException(logger, (Throwable)exception);
        }
        return string2;
    }

    public static String resolveHostname(String string) {
        String string2 = string;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            string2 = inetAddress.isLoopbackAddress() ? InetAddress.getLocalHost().getCanonicalHostName() : inetAddress.getCanonicalHostName();
        }
        catch (Exception exception) {
            Logger logger = Log.getGlobalLogger();
            DataLogger.lowImpactLogger(logger, Configuration.class, "resolveHostName", "Unable to obtain hostname for host string " + string, exception);
            ExceptionFactory.logException(logger, (Throwable)exception);
        }
        return string2;
    }

    private static boolean meetsLocalAddressRequirements(InetAddress inetAddress) {
        return !inetAddress.isLoopbackAddress();
    }

    private static boolean meetsGlobalAddressRequirements(InetAddress inetAddress) {
        return !inetAddress.isLoopbackAddress() && !inetAddress.isLinkLocalAddress() && !inetAddress.isSiteLocalAddress() && !inetAddress.isAnyLocalAddress() && !inetAddress.isMulticastAddress();
    }

    private static boolean isExtendedInsightLUWLicensedX() {
        return ExtendedInsightLicense.isLicensed();
    }

    private static boolean isExtendedInsightZosLicensedX() {
        return ExtendedInsightZosLicense.isLicensed();
    }

    private static void loadJCCAndCheckPrerequisite() {
        ClassLoader classLoader = null;
        try {
            classLoader = Configuration.getThreadContextClassLoaderNonPriv();
            Configuration.getClassForNameUsingClassLoader("com.ibm.db2.jcc.DB2Driver", classLoader);
            isJCCPresent__ = true;
        }
        catch (Throwable throwable) {
            isJCCPresent__ = false;
        }
        if (isJCCPresent__) {
            Configuration.setConfigurationCapabilities(classLoader);
        }
    }

    public static synchronized void setConfigurationCapabilities(ClassLoader classLoader) {
        Class<?> clazz = null;
        try {
            clazz = Configuration.getClassForNameUsingClassLoader("com.ibm.db2.jcc.DB2Version", classLoader);
            Method method = null;
            method = Configuration.getMethodForClass(clazz, "getVersion", new Class[0]);
            String string = (String)method.invoke(null, (Object[])null);
            if (string != null && !string.equals(JCCVersionAsString__)) {
                JCCVersionAsString__ = string;
                jccDriverPath__ = Configuration.getPath(clazz);
                method = Configuration.getMethodForClass(clazz, "getMajorVersion", new Class[0]);
                JCCMajorVersion__ = (Integer)method.invoke(null, (Object[])null);
                method = Configuration.getMethodForClass(clazz, "getMinorVersion", new Class[0]);
                JCCMinorVersion__ = (Integer)method.invoke(null, (Object[])null);
                method = Configuration.getMethodForClass(clazz, "getBuildNumber", new Class[0]);
                JCCBuildNumber__ = (Integer)method.invoke(null, (Object[])null);
                method = Configuration.getMethodForClass(clazz, "getDriverName", new Class[0]);
                JCCDriverName__ = (String)method.invoke(null, (Object[])null);
                method = Configuration.getMethodForClass(clazz, "getReleaseCertification", new Class[0]);
                JCCReleaseCertification__ = (Integer)method.invoke(null, (Object[])null);
                isJCCAtPrerequisiteLevel__ = Configuration.checkIfFunctionalityIsAvailableInJCCVersion(57, 7);
                isJCCAtEI3ProtocolLevel__ = Configuration.checkIfFunctionalityIsAvailableInJCCVersion(59, 9);
                isJCCAtCMX5ProtocolLevel__ = Configuration.checkIfFunctionalityIsAvailableInJCCVersion(63, 13);
                isJCCAtCMX9ProtocolLevel__ = Configuration.checkIfFunctionalityIsAvailableInJCCVersion(65, 15);
                isMonitorSPSupported__ = Configuration.checkIfFunctionalityIsAvailableInJCCVersion(63, 13);
                Configuration.determineWhatTheJccVersionSupports(classLoader);
            }
        }
        catch (Throwable throwable) {
            isJCCAtPrerequisiteLevel__ = false;
        }
    }

    private static String getPath(Class<?> clazz) {
        try {
            String string = clazz.getName();
            String string2 = string.replace('.', '/') + ".class";
            String string3 = clazz.getClassLoader().getResource(string2).getPath();
            int n2 = string3.indexOf("!");
            if (n2 >= 0) {
                return string3.substring(0, n2);
            }
            return string3;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean checkIfFunctionalityIsAvailableInJCCVersion(int n2, int n3) {
        return isJCCPresent__ && 3 == JCCMajorVersion__ && JCCMinorVersion__ >= n2 || 4 == JCCMajorVersion__ && JCCMinorVersion__ >= n3;
    }

    public static void printProductNameAndCopyrightInformation(PrintWriter printWriter) {
        if (null == printWriter) {
            printWriter = new PrintWriter(System.out, true);
        }
        printWriter.println();
        printWriter.println();
        printWriter.println(DataVersion.getProductNameAndVersion());
        printWriter.println(copyrightNoticeForCommandLineOutput__);
        printWriter.println();
    }

    public static String getJCCVersionNotSupportedMessage() {
        return Messages.getText("ERR_JCC_PREREQUISITE_NOT_MET_NEW", JCCVersionAsString__, dataStudioVersion__, JCC3PrereqAsString__, JCC4PrereqAsString__);
    }

    public static void checkCompatibilityOfXmlForClientOptmizer(Element element) throws XmlFormatNotSupported {
        if (element == null) {
            throw new XmlFormatNotSupported(Messages.getText("ERR_XML_FILE", new Object[0]));
        }
        Configuration.checkOriginType(element);
        int n2 = Integer.valueOf(xmlSchemaVersion__);
        int n3 = Integer.MAX_VALUE;
        if (element.hasAttribute("version")) {
            n3 = Integer.valueOf(element.getAttribute("version"));
        }
        if (n2 < n3) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_PROFILER_INCOMPAT_TOOLS", n3, "IBM InfoSphere Optim pureQuery Runtime 3.3.0.6"), null, 10520);
        }
    }

    private static void checkOriginType(Element element) throws XmlFormatNotSupported {
        if (element == null) {
            throw new XmlFormatNotSupported(Messages.getText("ERR_XML_FILE", new Object[0]));
        }
        if (!"programSet".equals(element.getTagName())) {
            throw new XmlFormatNotSupported(Messages.getText("ERR_XML_FILE", new Object[0]));
        }
        String string = element.getAttribute("version");
        if (string == null || string.matches("\\s*") || Configuration.parseVersion(string) < 4) {
            NodeList nodeList = element.getElementsByTagName("origin");
            if (nodeList != null && nodeList.getLength() > 0) {
                String string2;
                Element element2 = (Element)nodeList.item(0);
                if (!((nodeList = element2.getElementsByTagName("originType")) == null || nodeList.getLength() <= 0 || "ClientOptimizer".equals(string2 = (element2 = (Element)nodeList.item(0)).getTextContent()) || "pureQueryCapture".equals(string2) || "pureQueryCaptureCLI".equals(string2) || "pureQueryCaptureDotNET".equals(string2))) {
                    throw new XmlFormatNotSupported(Messages.getText("ERR_XML_ORIGIN_NOT_SUP", string2));
                }
            } else {
                throw new XmlFormatNotSupported(Messages.getText("ERR_XML_FILE", new Object[0]));
            }
        }
    }

    private static int parseVersion(String string) {
        return Integer.parseInt(string);
    }

    public static boolean isGatewayGreaterThanOrEqualTo(String string, int n2, int n3, char c10) {
        if (string == null) {
            return false;
        }
        int n4 = Integer.parseInt(string.substring(3, 5));
        int n5 = Integer.parseInt(string.substring(5, 7));
        char c11 = string.substring(7, 8).charAt(0);
        if (n4 > n2) {
            return true;
        }
        if (n4 == n2) {
            if (n5 > n3) {
                return true;
            }
            if (n5 == n3 && c11 >= c10) {
                return true;
            }
        }
        return false;
    }

    public static boolean isProductDB2Z(String string) {
        if (string == null || string.length() < 3) {
            return false;
        }
        String string2 = string.substring(0, 3);
        return string2.equalsIgnoreCase("DSN");
    }

    private static void setExtendedInsightMaxClientProtocolLevels() {
        extendedInsightMonitorProtocolClientMaxLevel__ = !Configuration.checkIfFunctionalityIsAvailableInJCCVersion(59, 9) ? (!Configuration.checkIfFunctionalityIsAvailableInJCCVersion(58, 8) ? 1 : 2) : 3;
    }

    private static void determineWhatTheJccVersionSupports(ClassLoader classLoader) {
        int n2;
        for (n2 = 0; n2 < jccFeatures__.length; ++n2) {
            try {
                Configuration.jccFeatures__[n2].isSupportedByJCCVersionInUse_ = Configuration.checkIfFunctionalityIsAvailableInJCCVersion(Configuration.jccFeatures__[n2].jcc3MinorVersionWhereAdded_, Configuration.jccFeatures__[n2].jcc4MinorVersionWhereAdded_);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        n2 = 0;
        if (!Configuration.jccFeatures__[n2].isSupportedByJCCVersionInUse_) {
            try {
                Class<?> clazz = Configuration.getClassForNameUsingClassLoader("sqlj.runtime.profile.EntryInfo", classLoader);
                if (576 == (Integer)Configuration.getValueOfStaticField(clazz, "AUTO_GENERATED_KEY_STMT_INSERT") && 577 == (Integer)Configuration.getValueOfStaticField(clazz, "AUTO_GENERATED_KEY_STMT_UPDATE") && 578 == (Integer)Configuration.getValueOfStaticField(clazz, "AUTO_GENERATED_KEY_STMT_DELETE") && 579 == (Integer)Configuration.getValueOfStaticField(clazz, "AUTO_GENERATED_KEY_STMT_MERGE")) {
                    Configuration.jccFeatures__[n2].isSupportedByJCCVersionInUse_ = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean doesJccVersionSupportFeature(int n2) {
        JccFeature jccFeature;
        boolean bl2 = false;
        if (0 <= n2 && jccFeatures__.length > n2 && null != (jccFeature = jccFeatures__[n2])) {
            bl2 = jccFeature.isSupportedByJCCVersionInUse_;
        }
        return bl2;
    }

    public static String getJccVersionWhereFeatureIntroduced(int n2, int n3) {
        JccFeature jccFeature;
        String string = null;
        if (0 <= n2 && jccFeatures__.length > n2 && null != (jccFeature = jccFeatures__[n2])) {
            switch (n3) {
                case 3: {
                    string = "3." + jccFeature.jcc3MinorVersionWhereAdded_;
                    break;
                }
                case 4: {
                    string = "4." + jccFeature.jcc4MinorVersionWhereAdded_;
                }
            }
        }
        return string;
    }

    private static Object getValueOfStaticField(Class<?> clazz, String string) {
        try {
            return Configuration.getValueOfStaticFieldNoSM(clazz, string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Object getValueOfStaticFieldNoSM(Class<?> clazz, String string) throws SecurityException, NoSuchFieldException, IllegalAccessException {
        return clazz.getField(string).get(null);
    }

    public static boolean isUnwrappedConnectionAJccDB2Connection(Connection connection) {
        return isJCCPresent__ && Configuration.isUnwrappedConnectionAJccDB2Connection_jccIsPresent(connection);
    }

    private static boolean isUnwrappedConnectionAJccDB2Connection_jccIsPresent(Connection connection) {
        return null != connection && connection instanceof DB2Connection;
    }

    private static Method getMethodForClass(Class clazz, String string, Class ... classArray) throws NoSuchMethodException {
        return Configuration.getMethodForClassNoSM(clazz, string, classArray);
    }

    private static Method getMethodForClassNoSM(Class clazz, String string, Class ... classArray) throws SecurityException, NoSuchMethodException {
        return clazz.getMethod(string, classArray);
    }

    private static ClassLoader getThreadContextClassLoaderNonPriv() throws SecurityException {
        return Thread.currentThread().getContextClassLoader();
    }

    private static Class<?> getClassForNameUsingClassLoader(String string, ClassLoader classLoader) throws Exception {
        return Configuration.getClassForNameUsingClassLoaderNonPriv(string, classLoader);
    }

    private static Class<?> getClassForNameUsingClassLoaderNonPriv(String string, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(string, true, classLoader);
    }

    static {
        localHostAddress__ = "localhost";
        myHostAddresses__ = null;
        extendedInsightMonitorProtocolClientMaxLevel__ = 3;
        extendedInsightControllerProtocolClientMaxLevel__ = 3;
        jccFeatures__ = new JccFeature[4];
        Configuration.jccFeatures__[0] = new JccFeature(61, 11);
        Configuration.jccFeatures__[1] = new JccFeature(59, 9);
        Configuration.jccFeatures__[2] = new JccFeature(Integer.MAX_VALUE, 18);
        Configuration.jccFeatures__[3] = new JccFeature(67, 17);
        Configuration.loadLicense();
        Configuration.loadJCCAndCheckPrerequisite();
        pureQueryDriverPath__ = Configuration.getPath(BuildVersion.class);
        Configuration.setExtendedInsightMaxClientProtocolLevels();
        if (Log.getGlobalLogger().isLoggable(Level.CONFIG)) {
            Log.getGlobalLogger().log(Level.CONFIG, DataVersion.getConfiguration());
        }
        Configuration.loadLocalHostAddresses();
    }
}

