/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.MutableDatabaseInfo;
import schemacrawler.crawl.MutableJdbcDriverInfo;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.JdbcDriverInfo;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public final class ConnectionInfoBuilder {
    private static final Logger LOGGER = Logger.getLogger(ConnectionInfoBuilder.class.getName());
    private final DatabaseMetaData dbMetaData;

    public static ConnectionInfoBuilder builder(Connection connection) throws SQLException {
        return new ConnectionInfoBuilder(connection);
    }

    private static <T> T getConnectionInfoProperty(Callable<T> propertyFunction, T defaultValue) {
        if (propertyFunction == null) {
            return defaultValue;
        }
        try {
            return propertyFunction.call();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Could not get connection info property", e);
            return defaultValue;
        }
    }

    private static String getConnectionUrl(DatabaseMetaData dbMetaData) {
        if (dbMetaData == null) {
            return "";
        }
        try {
            return dbMetaData.getURL();
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, new StringFormat("Could not obtain the database connection URL", e));
            return "";
        }
    }

    private static Driver getJdbcDriver(String connectionUrl) {
        if (Utility.isBlank(connectionUrl)) {
            return null;
        }
        try {
            return DriverManager.getDriver(connectionUrl);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, new StringFormat("Could not find a suitable JDBC driver for database connection URL <%s>", connectionUrl, e));
            return null;
        }
    }

    private ConnectionInfoBuilder(Connection connection) throws SQLException {
        Objects.requireNonNull(connection, "No connection provided");
        this.dbMetaData = connection.getMetaData();
        Objects.requireNonNull(this.dbMetaData, "No database metadata available");
    }

    public DatabaseInfo buildDatabaseInfo() throws SQLException {
        return new MutableDatabaseInfo(ConnectionInfoBuilder.getConnectionInfoProperty(() -> this.dbMetaData.getDatabaseProductName(), ""), ConnectionInfoBuilder.getConnectionInfoProperty(() -> this.dbMetaData.getDatabaseProductVersion(), ""), ConnectionInfoBuilder.getConnectionInfoProperty(() -> this.dbMetaData.getUserName(), ""));
    }

    public JdbcDriverInfo buildJdbcDriverInfo() throws SQLException {
        boolean isJdbcCompliant;
        String jdbcDriverClassName;
        String connectionUrl = ConnectionInfoBuilder.getConnectionUrl(this.dbMetaData);
        Driver jdbcDriver = ConnectionInfoBuilder.getJdbcDriver(connectionUrl);
        if (jdbcDriver != null) {
            jdbcDriverClassName = jdbcDriver.getClass().getName();
            isJdbcCompliant = jdbcDriver.jdbcCompliant();
        } else {
            jdbcDriverClassName = "";
            isJdbcCompliant = false;
        }
        return new MutableJdbcDriverInfo(ConnectionInfoBuilder.getConnectionInfoProperty(() -> this.dbMetaData.getDriverName(), ""), jdbcDriverClassName, ConnectionInfoBuilder.getConnectionInfoProperty(() -> this.dbMetaData.getDriverVersion(), ""), ConnectionInfoBuilder.getConnectionInfoProperty(() -> this.dbMetaData.getDriverMajorVersion(), 0), ConnectionInfoBuilder.getConnectionInfoProperty(() -> this.dbMetaData.getDriverMinorVersion(), 0), ConnectionInfoBuilder.getConnectionInfoProperty(() -> this.dbMetaData.getJDBCMajorVersion(), 0), ConnectionInfoBuilder.getConnectionInfoProperty(() -> this.dbMetaData.getJDBCMinorVersion(), 0), isJdbcCompliant, connectionUrl);
    }
}

