/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.weakassociations;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import schemacrawler.loader.weakassociations.ProposedWeakAssociation;
import schemacrawler.schema.Column;

public final class IdMatcher
implements Predicate<ProposedWeakAssociation> {
    private static final Pattern endsWithIdPattern = Pattern.compile(".*(?i)_?id$");
    private static final Pattern isIdPattern = Pattern.compile("^(?i)_?id$");

    @Override
    public boolean test(ProposedWeakAssociation proposedWeakAssociation) {
        if (proposedWeakAssociation == null) {
            return false;
        }
        Column foreignKeyColumn = proposedWeakAssociation.getForeignKeyColumn();
        Column primaryKeyColumn = proposedWeakAssociation.getPrimaryKeyColumn();
        boolean fkColEndsWithId = endsWithIdPattern.matcher(foreignKeyColumn.getName()).matches();
        boolean pkColEndsWithId = endsWithIdPattern.matcher(primaryKeyColumn.getName()).matches() && !isIdPattern.matcher(primaryKeyColumn.getName()).matches();
        return fkColEndsWithId && !pkColEndsWithId;
    }
}

