/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function.builtins.clinic;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.truffle.api.dsl.Specialization;

public abstract class IntConversionBaseNode
extends ArgumentCastNode {
    private final int defaultValue;
    protected final boolean useDefaultForNone;

    protected IntConversionBaseNode(int defaultValue, boolean useDefaultForNone) {
        this.defaultValue = defaultValue;
        this.useDefaultForNone = useDefaultForNone;
    }

    @Specialization(guards={"!useDefaultForNone", "isNoValue(none)"})
    int doNoValue(PNone none) {
        return this.defaultValue;
    }

    @Specialization(guards={"useDefaultForNone"})
    int doNoValueAndNone(PNone none) {
        return this.defaultValue;
    }

    @Specialization
    static int doInt(int i) {
        return i;
    }

    @Specialization(guards={"fitsInInt(l)"})
    static int doLong(long l) {
        return (int)l;
    }

    protected static boolean fitsInInt(long l) {
        return (long)((int)l) == l;
    }

    protected boolean isHandledPNone(Object value) {
        return IntConversionBaseNode.isHandledPNone(this.useDefaultForNone, value);
    }
}

