/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.floats;

import com.oracle.graal.python.builtins.objects.floats.FloatUtils;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.UnexpectedResultException;

@GeneratedBy(value=FloatUtils.PFloatUnboxing.class)
public final class PFloatUnboxingGen
extends FloatUtils.PFloatUnboxing {
    protected PFloatUnboxingGen() {
    }

    public static double expectImplicitDouble(int state, Object value) throws UnexpectedResultException {
        if ((state & 1) != 0 && value instanceof Double) {
            return (Double)value;
        }
        if ((state & 2) != 0 && value instanceof PFloat) {
            return PFloatUnboxingGen.PFloatToDouble((PFloat)value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isImplicitDouble(int state, Object value) {
        return (state & 1) != 0 && value instanceof Double || (state & 2) != 0 && value instanceof PFloat;
    }

    public static boolean isImplicitDouble(Object value) {
        return value instanceof Double || value instanceof PFloat;
    }

    public static double asImplicitDouble(int state, Object value) {
        if (HostCompilerDirectives.inInterpreterFastPath()) {
            return PFloatUnboxingGen.asImplicitDouble(value);
        }
        if ((state & 1) != 0 && value instanceof Double) {
            return (Double)value;
        }
        if ((state & 2) != 0 && value instanceof PFloat) {
            return PFloatUnboxingGen.PFloatToDouble((PFloat)value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalArgumentException("Illegal implicit source type.");
    }

    public static double asImplicitDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof PFloat) {
            return PFloatUnboxingGen.PFloatToDouble((PFloat)value);
        }
        throw new IllegalArgumentException("Illegal implicit source type.");
    }

    public static int specializeImplicitDouble(Object value) {
        if (value instanceof Double) {
            return 1;
        }
        if (value instanceof PFloat) {
            return 2;
        }
        return 0;
    }
}

