/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jline.console.CommandRegistry;
import org.jline.console.impl.SystemRegistryImpl;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.MaskingCallback;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.terminal.TerminalBuilder;
import picocli.CommandLine;
import picocli.shell.jline3.PicocliCommands;
import schemacrawler.tools.commandline.SchemaCrawlerShellCommands;
import schemacrawler.tools.commandline.state.ShellState;
import schemacrawler.tools.commandline.state.StateFactory;
import schemacrawler.tools.commandline.utility.CommandLineLogger;
import schemacrawler.tools.commandline.utility.CommandLineUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.UtilityLogger;

public final class SchemaCrawlerShell {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawlerShell.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static int execute(String[] args) {
        state = new ShellState();
        try {
            try {
                terminal = TerminalBuilder.builder().build();
                try {
                    Objects.requireNonNull(args, "No arguments provided");
                    stateFactory = new StateFactory(state);
                    factory = new PicocliCommands.PicocliCommandsFactory((CommandLine.IFactory)stateFactory);
                    commands = new SchemaCrawlerShellCommands();
                    commandLine = CommandLineUtility.newCommandLine(commands, (CommandLine.IFactory)factory);
                    loadCommandLine = commandLine.getSubcommands().getOrDefault("load", null);
                    if (loadCommandLine != null) {
                        CommandLineUtility.addPluginCommands(loadCommandLine, CommandLineUtility.catalogLoaderPluginCommands);
                        commandLine.addSubcommand((Object)loadCommandLine);
                    }
                    if ((executeCommandLine = (CommandLine)commandLine.getSubcommands().getOrDefault("execute", null)) != null) {
                        CommandLineUtility.addPluginCommands(executeCommandLine, CommandLineUtility.commandPluginCommands);
                        commandLine.addSubcommand((Object)executeCommandLine);
                    }
                    commandLine.setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Exception;Lpicocli/CommandLine;Lpicocli/CommandLine$ParseResult;)I, lambda$execute$0(java.lang.Exception picocli.CommandLine picocli.CommandLine$ParseResult ), (Ljava/lang/Exception;Lpicocli/CommandLine;Lpicocli/CommandLine$ParseResult;)I)());
                    workingDir = (Supplier<Path>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$execute$1(), ()Ljava/nio/file/Path;)();
                    picocliCommands = new PicocliCommands(commandLine);
                    parser = new DefaultParser().escapeChars(new char[0]);
                    systemRegistry = new SystemRegistryImpl((Parser)parser, terminal, workingDir, null);
                    systemRegistry.setCommandRegistries(new CommandRegistry[]{picocliCommands});
                    systemRegistry.register("help", (CommandRegistry)picocliCommands);
                    reader = LineReaderBuilder.builder().terminal(terminal).completer(systemRegistry.completer()).parser((Parser)parser).variable("list-max", (Object)3).build();
                    factory.setTerminal(terminal);
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        try {
                            while (true) {
                                systemRegistry.cleanUp();
                                line = reader.readLine("schemacrawler> ", null, (MaskingCallback)null, null);
                                if (line.startsWith("help")) {
                                    pl = reader.getParser().parse(line, 0);
                                    arguments = pl.words().toArray(new String[0]);
                                    commandLine.execute(arguments);
                                    continue;
                                }
                                if ("cls".equals(line) || "clear".equals(line)) {
                                    ((LineReaderImpl)reader).clearScreen();
                                    continue;
                                }
                                if ("quit".equals(line) || "terminate".equals(line)) {
                                    throw new EndOfFileException(line);
                                }
                                systemRegistry.execute(line);
                            }
                        }
                        catch (UserInterruptException line) {
                        }
                        catch (EndOfFileException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            SchemaCrawlerShell.LOGGER.log(Level.WARNING, e.getMessage(), e);
                            systemRegistry.trace((Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable var3_6) {
                    if (terminal != null) {
                        try {
                            terminal.close();
                        }
                        catch (Throwable var4_10) {
                            var3_6.addSuppressed(var4_10);
                        }
                    }
                    throw var3_6;
                }
                ** GOTO lbl-1000
            }
            catch (EndOfFileException e) {
                var3_7 = 0;
                return var3_7;
            }
            catch (Throwable throwable) {
                SchemaCrawlerShell.handleFatalError(args, throwable, state);
                var3_8 = 1;
                state.close();
                return var3_8;
            }
        }
        finally {
            state.close();
        }
    }

    private static void handleFatalError(String[] args, Throwable throwable, ShellState state) {
        Throwable cause;
        UtilityLogger logger = new UtilityLogger(LOGGER);
        logger.logSafeArguments(args);
        logger.logFatalStackTrace(throwable);
        CommandLineLogger commandLineLogger = new CommandLineLogger(LOGGER);
        commandLineLogger.logState(state);
        String errorMessage = throwable instanceof CommandLine.PicocliException ? ((cause = throwable.getCause()) != null && !Utility.isBlank((String)cause.getMessage()) ? cause.getMessage() : throwable.getMessage()) : throwable.getMessage();
        CommandLineUtility.printCommandLineErrorMessage(errorMessage, state);
    }

    private SchemaCrawlerShell() {
    }

    private static /* synthetic */ Path lambda$execute$1() {
        return Path.of(".", new String[0]);
    }

    private static /* synthetic */ int lambda$execute$0(Exception ex, CommandLine cmdLine, CommandLine.ParseResult parseResult) throws Exception {
        if (ex != null && ex.getMessage() != null) {
            cmdLine.getErr().printf("ERROR: %s%n", ex.getMessage());
        }
        return 0;
    }
}

