/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.flavor.oracledb;

import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.flavor.oracledb.OracleDBFlags;
import com.oracle.truffle.regex.flavor.oracledb.OracleDBRegexLexer;
import com.oracle.truffle.regex.flavor.oracledb.OracleDBRegexParser;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import com.oracle.truffle.regex.tregex.parser.MultiCharacterCaseFolding;
import com.oracle.truffle.regex.tregex.parser.RegexFlavor;
import com.oracle.truffle.regex.tregex.parser.RegexLexer;
import com.oracle.truffle.regex.tregex.parser.RegexParser;
import com.oracle.truffle.regex.tregex.parser.RegexValidator;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;

public final class OracleDBFlavor
extends RegexFlavor {
    public static final OracleDBFlavor INSTANCE = new OracleDBFlavor();

    private OracleDBFlavor() {
        super(1805);
    }

    @Override
    public String getName() {
        return "OracleDB";
    }

    @Override
    public RegexValidator createValidator(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RegexLexer createLexer(RegexSource source, CompilationBuffer compilationBuffer) {
        return new OracleDBRegexLexer(source, OracleDBFlags.parseFlags(source), compilationBuffer);
    }

    @Override
    public RegexParser createParser(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) {
        return new OracleDBRegexParser(language, source, compilationBuffer);
    }

    @Override
    public RegexFlavor.EqualsIgnoreCasePredicate getEqualsIgnoreCasePredicate(RegexAST ast) {
        return (codePointA, codePointB, altMode) -> MultiCharacterCaseFolding.equalsIgnoreCase(CaseFoldData.CaseFoldAlgorithm.OracleDB, codePointA, codePointB);
    }

    @Override
    public CaseFoldData.CaseFoldAlgorithm getCaseFoldAlgorithm(RegexAST ast) {
        OracleDBFlags flags = (OracleDBFlags)ast.getFlavorSpecificFlags();
        if (flags.isIgnoreCase()) {
            return CaseFoldData.CaseFoldAlgorithm.OracleDB;
        }
        return null;
    }
}

