/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.repository;

import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import com.ibm.db2.cmx.tools.internal.repository.ConnectionDescriptor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Set;

public class ConnectionDescriptorFactory {
    public static final String repositoryConnectionName = "repository";
    public static final String incrementalRepositoryConnectionName = "incrementalRepository";
    private static String[] connectionPropertyPrefixes = new String[]{"repository", "incrementalRepository"};
    private static String[] connectionPropertySuffixes = new String[]{"url", "username", "password", "driverClass"};

    public static Hashtable<String, ConnectionDescriptor> getConnectionDescriptors(ArtifactOptionsSet artifactOptionsSet) throws Exception {
        Hashtable<String, ConnectionDescriptor> hashtable = null;
        Hashtable<String, PossibleArgs> hashtable2 = ConnectionDescriptorFactory.getSpecifiedOptions(artifactOptionsSet);
        for (int i10 = 0; i10 < connectionPropertyPrefixes.length; ++i10) {
            ConnectionDescriptor connectionDescriptor = new ConnectionDescriptor();
            boolean bl2 = false;
            for (int i11 = 0; i11 < connectionPropertySuffixes.length; ++i11) {
                String string = (connectionPropertyPrefixes[i10] + connectionPropertySuffixes[i11]).toLowerCase();
                PossibleArgs possibleArgs = hashtable2.get(string);
                if (possibleArgs == null) continue;
                if (!bl2) {
                    if (hashtable == null) {
                        hashtable = new Hashtable<String, ConnectionDescriptor>();
                    }
                    hashtable.put(connectionPropertyPrefixes[i10], connectionDescriptor);
                    bl2 = true;
                }
                Class[] classArray = new Class[]{String.class};
                Method method = ConnectionDescriptor.class.getMethod("set" + ConnectionDescriptorFactory.capitalizeString(connectionPropertySuffixes[i11]), classArray);
                method.invoke((Object)connectionDescriptor, artifactOptionsSet.getOptionOrArtifactSingleValue(possibleArgs));
            }
        }
        return hashtable;
    }

    private static Hashtable<String, PossibleArgs> getSpecifiedOptions(ArtifactOptionsSet artifactOptionsSet) {
        Set<PossibleArgs> set = artifactOptionsSet.getAllOptionsAndArtifactsSpecified();
        Hashtable<String, PossibleArgs> hashtable = new Hashtable<String, PossibleArgs>();
        for (PossibleArgs possibleArgs : set) {
            hashtable.put(possibleArgs.externalOptionNameWithoutDash().toLowerCase(), possibleArgs);
        }
        return hashtable;
    }

    private static String capitalizeString(String string) {
        if (string.length() == 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }
}

