/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.datasource;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.SQLRuntimeException;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.string.StringFormat;

abstract class AbstractDatabaseConnectionSource
implements DatabaseConnectionSource {
    private static final Logger LOGGER = Logger.getLogger(AbstractDatabaseConnectionSource.class.getName());
    protected Consumer<Connection> connectionInitializer;

    protected static Properties createConnectionProperties(String connectionUrl, Map<String, String> connectionProperties, String user, String password) {
        Properties jdbcConnectionProperties;
        List<String> skipProperties = List.of("server", "host", "port", "database", "urlx", "user", "password", "url");
        try {
            Driver jdbcDriver = AbstractDatabaseConnectionSource.getJdbcDriver(connectionUrl);
            DriverPropertyInfo[] propertyInfo = jdbcDriver.getPropertyInfo(connectionUrl, new Properties());
            HashMap<String, Boolean> jdbcDriverProperties = new HashMap<String, Boolean>();
            for (DriverPropertyInfo driverPropertyInfo : propertyInfo) {
                String jdbcPropertyName = driverPropertyInfo.name.toLowerCase();
                if (skipProperties.contains(jdbcPropertyName)) continue;
                jdbcDriverProperties.put(jdbcPropertyName, driverPropertyInfo.required);
            }
            jdbcConnectionProperties = new Properties();
            if (user != null) {
                jdbcConnectionProperties.setProperty("user", user);
            }
            if (password != null) {
                jdbcConnectionProperties.setProperty("password", password);
            }
            if (connectionProperties != null) {
                for (Map.Entry entry : connectionProperties.entrySet()) {
                    String property = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (!jdbcDriverProperties.containsKey(property.toLowerCase()) || value == null) continue;
                    jdbcConnectionProperties.setProperty(property, value);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLRuntimeException("Could not get connection properties", e);
        }
        return jdbcConnectionProperties;
    }

    protected static Connection getConnection(String connectionUrl, Properties jdbcConnectionProperties) {
        String user = jdbcConnectionProperties.getProperty("user");
        String username = user != null ? "user '%s'".formatted(user) : "unspecified user";
        try {
            LOGGER.log(Level.INFO, new StringFormat("Making connection to %s%nfor user '%s', with properties %s", connectionUrl, username, AbstractDatabaseConnectionSource.safeProperties(jdbcConnectionProperties)));
            Driver driver = AbstractDatabaseConnectionSource.getJdbcDriver(connectionUrl);
            Connection connection = driver.connect(connectionUrl, jdbcConnectionProperties);
            LOGGER.log(Level.INFO, new StringFormat("Opened database connection <%s>", connection));
            return connection;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException("Could not connect to <%s>, for <%s>, with properties <%s>".formatted(connectionUrl, username, AbstractDatabaseConnectionSource.safeProperties(jdbcConnectionProperties)), e);
        }
    }

    private static Driver getJdbcDriver(String connectionUrl) throws SQLException {
        try {
            return DriverManager.getDriver(connectionUrl);
        }
        catch (SQLException e) {
            throw new SQLException("Could not find a suitable JDBC driver for database connection URL <%s>".formatted(connectionUrl), e);
        }
    }

    private static Properties safeProperties(Properties properties) {
        Properties logProperties = new Properties(properties);
        logProperties.remove("password");
        return logProperties;
    }

    public AbstractDatabaseConnectionSource(Consumer<Connection> connectionInitializer) {
        this.connectionInitializer = Objects.requireNonNull(connectionInitializer, "No connection initializer provided");
    }

    @Override
    public void setFirstConnectionInitializer(Consumer<Connection> connectionInitializer) {
        if (connectionInitializer != null) {
            this.connectionInitializer = connectionInitializer.andThen(this.connectionInitializer);
        }
    }
}

