/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.thrift.transport;

import com.jetbrains.cef.remote.thrift.TConfiguration;
import com.jetbrains.cef.remote.thrift.transport.AutoExpandingBuffer;
import com.jetbrains.cef.remote.thrift.transport.TEndpointTransport;
import com.jetbrains.cef.remote.thrift.transport.TTransport;
import com.jetbrains.cef.remote.thrift.transport.TTransportException;

public class AutoExpandingBufferReadTransport
extends TEndpointTransport {
    private final AutoExpandingBuffer buf;
    private int pos = 0;
    private int limit = 0;

    public AutoExpandingBufferReadTransport(TConfiguration config, int initialCapacity) throws TTransportException {
        super(config);
        this.buf = new AutoExpandingBuffer(initialCapacity);
    }

    public void fill(TTransport inTrans, int length) throws TTransportException {
        this.buf.resizeIfNecessary(length);
        inTrans.readAll(this.buf.array(), 0, length);
        this.pos = 0;
        this.limit = length;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void open() throws TTransportException {
    }

    @Override
    public final int read(byte[] target, int off, int len) throws TTransportException {
        int amtToRead = Math.min(len, this.getBytesRemainingInBuffer());
        if (amtToRead > 0) {
            System.arraycopy(this.buf.array(), this.pos, target, off, amtToRead);
            this.consumeBuffer(amtToRead);
        }
        return amtToRead;
    }

    @Override
    public void write(byte[] buf, int off, int len) throws TTransportException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void consumeBuffer(int len) {
        this.pos += len;
    }

    @Override
    public final byte[] getBuffer() {
        return this.buf.array();
    }

    @Override
    public final int getBufferPosition() {
        return this.pos;
    }

    @Override
    public final int getBytesRemainingInBuffer() {
        return this.limit - this.pos;
    }
}

