/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.utils;

import ai.grazie.nlp.langs.Language;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.ide.inspection.grammar.GrazieInspection;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringOperation;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HighlightingUtil {
    public static final Comparator<TextContent> BY_TEXT_START = Comparator.comparing(tc -> tc.textOffsetToFile(0));
    private static final Pattern trackerIssuePrefix = Pattern.compile("\\s*([A-Z]\\w+-\\d+):?\\s+.*");

    public static boolean skipExpensivePrecommitAnalysis(PsiFile file) {
        for (PsiFile root : file.getViewProvider().getAllFiles()) {
            Function function = InspectionProfileWrapper.getCustomInspectionProfileWrapper((PsiFile)root);
            if (function == null || !function.getClass().getName().contains("com.intellij.codeInsight.daemon.impl.MainPassesRunner") || !Registry.is((String)"grazie.skip.precommit.checks")) continue;
            return true;
        }
        return false;
    }

    public static Set<TextContent.TextDomain> checkedDomains() {
        return GrazieInspection.Companion.checkedDomains();
    }

    public static TextRange selectionRange(Editor editor) {
        return new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
    }

    public static ModificationTracker grazieConfigTracker() {
        return (ModificationTracker)ApplicationManager.getApplication().getService(GrazieConfig.class);
    }

    public static boolean isTooLargeText(List<TextContent> texts) {
        return texts.stream().mapToInt(t -> t.length()).sum() > 50000;
    }

    public static void applyTextChanges(Document document, List<StringOperation> changes) {
        for (StringOperation r : (StreamEx)StreamEx.of(changes).sortedBy(c -> -c.getRange().getStartOffset())) {
            document.replaceString(r.getRange().getStartOffset(), r.getRange().getEndOffset(), r.getReplacement());
        }
    }

    @Nullable
    public static Lang findInstalledLang(@NotNull Language language) {
        if (language == null) {
            HighlightingUtil.$$$reportNull$$$0(0);
        }
        return StreamEx.of(GrazieConfig.Companion.get().getAvailableLanguages()).findFirst(lang -> lang.getIso() == language.getIso()).orElse(null);
    }

    public static int stripPrefix(TextContent content) {
        int start = 0;
        String text = content.toString();
        if (CommitMessage.isCommitMessage((PsiElement)content.getContainingFile())) {
            if (text.startsWith("[")) {
                int rBrace = text.indexOf(93);
                if (rBrace >= 1 && rBrace <= 30) {
                    start = rBrace + 1;
                }
            } else {
                int colon = text.indexOf(58);
                if (colon >= 1 && colon <= 30 && text.substring(0, colon).chars().filter(Character::isWhitespace).count() <= 1L) {
                    start = colon + 1;
                }
            }
            Matcher issueMatch = trackerIssuePrefix.matcher(text.substring(start));
            if (issueMatch.matches()) {
                start += issueMatch.group(1).length() + 1;
            }
        }
        while (start < content.length() && Character.isWhitespace(content.charAt(start))) {
            ++start;
        }
        return start;
    }

    public static List<TextContent> getCheckedFileTexts(FileViewProvider vp) {
        return (List)CachedValuesManager.getManager((Project)vp.getManager().getProject()).getCachedValue((UserDataHolder)vp, () -> {
            List contents = ContainerUtil.sorted(TextExtractor.findAllTextContents(vp, HighlightingUtil.checkedDomains()), BY_TEXT_START);
            return CachedValueProvider.Result.create((Object)contents, (Object[])new Object[]{vp.getAllFiles().get(0), HighlightingUtil.grazieConfigTracker()});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/grazie/utils/HighlightingUtil", "findInstalledLang"));
    }
}

