/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.api;

import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.buildtools.api.ExperimentalBuildToolsApi;
import org.jetbrains.kotlin.buildtools.api.SharedApiClassesClassLoaderImpl;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\r\u0010\u0000\u001a\u00020\u0001H\u0007\u00a2\u0006\u0002\b\u0002\u001a-\u0010\u0003\u001a\u0002H\u0004\"\b\b\u0000\u0010\u0004*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"SharedApiClassesClassLoader", "Ljava/lang/ClassLoader;", "newInstance", "loadImplementation", "T", "", "cls", "Lkotlin/reflect/KClass;", "classLoader", "(Lkotlin/reflect/KClass;Ljava/lang/ClassLoader;)Ljava/lang/Object;", "kotlin-build-tools-api"})
@JvmName(name="SharedApiClassesClassLoader")
public final class SharedApiClassesClassLoader {
    @ExperimentalBuildToolsApi
    @JvmName(name="newInstance")
    @NotNull
    public static final ClassLoader newInstance() {
        ClassLoader classLoader = SharedApiClassesClassLoaderImpl.class.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"SharedApiClassesClassLoa\u2026l::class.java.classLoader");
        String string = SharedApiClassesClassLoaderImpl.class.getPackage().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SharedApiClassesClassLoa\u2026class.java.`package`.name");
        return new SharedApiClassesClassLoaderImpl(classLoader, string);
    }

    @NotNull
    public static final <T> T loadImplementation(@NotNull KClass<T> cls, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        ServiceLoader implementations = ServiceLoader.load(JvmClassMappingKt.getJavaClass(cls), classLoader);
        Intrinsics.checkNotNullExpressionValue(implementations, (String)"implementations");
        if (CollectionsKt.firstOrNull((Iterable)implementations) == null) {
            throw new IllegalStateException(("The classpath contains no implementation for " + cls.getQualifiedName()).toString());
        }
        Object object = CollectionsKt.singleOrNull((Iterable)implementations);
        if (object == null) {
            throw new IllegalStateException(("The classpath contains more than one implementation for " + cls.getQualifiedName()).toString());
        }
        return (T)object;
    }
}

