/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.parsers;

import com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.parsers.VSRegistryParserNew;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.utilities.VSHive;
import com.intellij.ide.startup.importSettings.utils.Ini;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.io.File;
import java.nio.file.Path;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0010\u0018\u0000 '2\u00020\u0001:\u0001'B%\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\"\u001a\u0004\u0018\u00010\u00182\u0006\u0010#\u001a\u00020\u0018H\u0002J\u0014\u0010$\u001a\u0004\u0018\u00010\u00182\b\u0010%\u001a\u0004\u0018\u00010\u0018H\u0002J\u0014\u0010&\u001a\u0004\u0018\u00010\u00182\b\u0010%\u001a\u0004\u0018\u00010\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0012\u0010\u0014R\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001c\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0016\u001a\u0004\b\u001d\u0010\u0014R\u001d\u0010\u001f\u001a\u0004\u0018\u00010\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0016\u001a\u0004\b \u0010\u001a\u00a8\u0006("}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/parsers/VSIsolationIniParser;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "hive", "Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/utilities/VSHive;", "file", "Ljava/io/File;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/utilities/VSHive;Ljava/io/File;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getHive", "()Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/utilities/VSHive;", "getFile", "()Ljava/io/File;", "ini", "Lcom/intellij/ide/startup/importSettings/utils/Ini;", "isPreview", "", "()Z", "isPreview$delegate", "Lkotlin/Lazy;", "edition", "", "getEdition", "()Ljava/lang/String;", "edition$delegate", "wasSetupFinished", "getWasSetupFinished", "wasSetupFinished$delegate", "installationVersion", "getInstallationVersion", "installationVersion$delegate", "get", "key", "vsShortIdToEditionDict", "shortId", "vsShortIdToEdition", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nVSIsolationIniParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VSIsolationIniParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/parsers/VSIsolationIniParser\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,119:1\n13#2:120\n*S KotlinDebug\n*F\n+ 1 VSIsolationIniParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/parsers/VSIsolationIniParser\n*L\n14#1:120\n*E\n"})
public final class VSIsolationIniParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final VSHive hive;
    @Nullable
    private final File file;
    @NotNull
    private final Ini ini;
    @NotNull
    private final Lazy isPreview$delegate;
    @NotNull
    private final Lazy edition$delegate;
    @NotNull
    private final Lazy wasSetupFinished$delegate;
    @NotNull
    private final Lazy installationVersion$delegate;
    @NotNull
    private static final Lifetime veryBadLifetime = Lifetime.Companion.getEternal();
    @NotNull
    private static final Logger logger;

    private VSIsolationIniParser(Lifetime lifetime, VSHive hive, File file) {
        File file2;
        this.lifetime = lifetime;
        this.hive = hive;
        this.file = file;
        this.isPreview$delegate = LazyKt.lazy(() -> VSIsolationIniParser.isPreview_delegate$lambda$0(this));
        this.edition$delegate = LazyKt.lazy(() -> VSIsolationIniParser.edition_delegate$lambda$0(this));
        this.wasSetupFinished$delegate = LazyKt.lazy(() -> VSIsolationIniParser.wasSetupFinished_delegate$lambda$0(this));
        this.installationVersion$delegate = LazyKt.lazy(() -> VSIsolationIniParser.installationVersion_delegate$lambda$0(this));
        File file3 = this.file;
        if (file3 == null) {
            file3 = VSIsolationIniParser.Companion.getIsolationFile(this.lifetime, this.hive);
        }
        if ((file2 = file3) == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this.ini = new Ini(file2);
    }

    /* synthetic */ VSIsolationIniParser(Lifetime lifetime, VSHive vSHive, File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            file = null;
        }
        this(lifetime, vSHive, file);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final VSHive getHive() {
        return this.hive;
    }

    @Nullable
    public final File getFile() {
        return this.file;
    }

    public final boolean isPreview() {
        Lazy lazy = this.isPreview$delegate;
        return (Boolean)lazy.getValue();
    }

    @Nullable
    public final String getEdition() {
        Lazy lazy = this.edition$delegate;
        return (String)lazy.getValue();
    }

    public final boolean getWasSetupFinished() {
        Lazy lazy = this.wasSetupFinished$delegate;
        return (Boolean)lazy.getValue();
    }

    @Nullable
    public final String getInstallationVersion() {
        Lazy lazy = this.installationVersion$delegate;
        return (String)lazy.getValue();
    }

    private final String get(String key) {
        return this.ini.get("Info", key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String vsShortIdToEditionDict(String shortId) {
        String string = shortId;
        if (string == null) return null;
        String string2 = string.toLowerCase(Locale.ROOT);
        String string3 = string2;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string4 = string3;
        if (string4 == null) return null;
        int n = -1;
        switch (string4.hashCode()) {
            case 114211: {
                if (string4.equals("std")) {
                    n = 1;
                }
                break;
            }
            case -802737311: {
                if (string4.equals("enterprise")) {
                    n = 2;
                }
                break;
            }
            case 100587: {
                if (string4.equals("ent")) {
                    n = 2;
                }
                break;
            }
            case 3629565: {
                if (string4.equals("vstt")) {
                    n = 3;
                }
                break;
            }
            case 3629549: {
                if (string4.equals("vstd")) {
                    n = 4;
                }
                break;
            }
            case 3629564: {
                if (string4.equals("vsts")) {
                    n = 5;
                }
                break;
            }
            case 104106: {
                if (string4.equals("ide")) {
                    n = 6;
                }
                break;
            }
            case -1480249367: {
                if (string4.equals("community")) {
                    n = 7;
                }
                break;
            }
            case 111277: {
                if (string4.equals("pro")) {
                    n = 8;
                }
                break;
            }
            case 3629546: {
                if (string4.equals("vsta")) {
                    n = 9;
                }
                break;
            }
            case 875077159: {
                if (string4.equals("professional")) {
                    n = 8;
                }
                break;
            }
        }
        switch (n) {
            case 7: {
                return "Community";
            }
            case 8: {
                return "Professional";
            }
            case 2: {
                return "Enterprise";
            }
            case 1: {
                return "Standard";
            }
            case 9: {
                return "Team Edition for Software Architects";
            }
            case 3: {
                return "Team Edition for Software Testers";
            }
            case 4: {
                return "Team Edition for Software Developers";
            }
            case 5: {
                return "Team Suite Edition";
            }
            case 6: {
                return "Shell Edition";
            }
            default: {
                return null;
            }
        }
    }

    private final String vsShortIdToEdition(String shortId) {
        if (shortId == null) {
            logger.debug("shortId null");
            return null;
        }
        if (this.vsShortIdToEditionDict(shortId) != null) {
            return this.vsShortIdToEditionDict(shortId);
        }
        logger.info("Unknown edition " + shortId);
        return null;
    }

    private static final boolean isPreview_delegate$lambda$0(VSIsolationIniParser this$0) {
        String string;
        String string2 = this$0.get("ChannelTitle");
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        return Intrinsics.areEqual((Object)string, (Object)"preview");
    }

    private static final String edition_delegate$lambda$0(VSIsolationIniParser this$0) {
        return this$0.vsShortIdToEdition(this$0.get("SKU"));
    }

    private static final boolean wasSetupFinished_delegate$lambda$0(VSIsolationIniParser this$0) {
        String string = this$0.get("SetupFinished");
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    private static final String installationVersion_delegate$lambda$0(VSIsolationIniParser this$0) {
        return this$0.get("InstallationVersion");
    }

    public /* synthetic */ VSIsolationIniParser(Lifetime lifetime, VSHive hive, File file, DefaultConstructorMarker $constructor_marker) {
        this(lifetime, hive, file);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VSIsolationIniParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VSIsolationIniParser.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/parsers/VSIsolationIniParser$Companion;", "", "<init>", "()V", "veryBadLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "create", "Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/parsers/VSIsolationIniParser;", "hive", "Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/utilities/VSHive;", "getIsolationFile", "Ljava/io/File;", "lifetime", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final VSIsolationIniParser create(@NotNull VSHive hive) {
            Intrinsics.checkNotNullParameter((Object)hive, (String)"hive");
            File file = this.getIsolationFile(veryBadLifetime, hive);
            if (file == null) {
                logger.info("file is null");
                return null;
            }
            if (!file.exists()) {
                if (hive.getInstanceId() != null) {
                    logger.warn("Visual Studio is new, but no isolation file. This incident will be reported.");
                } else {
                    logger.info("This Visual Studio is too old, no isolation file for you");
                }
                return null;
            }
            if (!file.canRead()) {
                logger.warn("Can't read file even though it exists. VS is running?");
                return null;
            }
            try {
                return new VSIsolationIniParser(veryBadLifetime, hive, file, null);
            }
            catch (Throwable t) {
                logger.warn("Failed to parse isolation file");
                logger.warn(t);
                return null;
            }
        }

        private final File getIsolationFile(Lifetime lifetime, VSHive hive) {
            Path dir;
            VSRegistryParserNew vSRegistryParserNew = hive.getRegistry();
            Object env = vSRegistryParserNew != null ? vSRegistryParserNew.getEnvPath() : null;
            Object object = env;
            Path path = object != null && (object = (Path)object.getFirst()) != null ? object.resolve("devenv.isolation.ini") : (dir = null);
            if (dir == null) {
                logger.info("dir null");
                return null;
            }
            File file = new File(((Object)dir).toString());
            if (!file.exists()) {
                logger.info("file is null");
                return null;
            }
            if (!file.canRead()) {
                logger.info("cant read file");
                return null;
            }
            return file;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

